/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuedThreadPool
extends AbstractLifeCycle
implements ThreadPool,
Executor {
    private final AtomicInteger _threadsStarted = new AtomicInteger();
    private final AtomicInteger _threadsIdle = new AtomicInteger();
    private final AtomicLong _lastShrink = new AtomicLong();
    private final ConcurrentLinkedQueue<Thread> _threads = new ConcurrentLinkedQueue();
    private final Object _joinLock = new Object();
    private BlockingQueue<Runnable> _jobs;
    private String _name;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 254;
    private int _minThreads = 8;
    private int _maxQueued = -1;
    private int _priority = 5;
    private boolean _daemon = false;
    private int _maxStopTime = 100;
    private Runnable _runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            shrink = false;
            try {
                try {
                    job = (Runnable)QueuedThreadPool.access$000(QueuedThreadPool.this).poll();
                    while (QueuedThreadPool.this.isRunning()) {
                        block18: {
                            while (job != null && QueuedThreadPool.this.isRunning()) {
                                job.run();
                                job = (Runnable)QueuedThreadPool.access$000(QueuedThreadPool.this).poll();
                            }
                            try {
                                QueuedThreadPool.access$100(QueuedThreadPool.this).incrementAndGet();
                                while (QueuedThreadPool.this.isRunning() && job == null) {
                                    if (QueuedThreadPool.access$200(QueuedThreadPool.this) <= 0) {
                                        job = (Runnable)QueuedThreadPool.access$000(QueuedThreadPool.this).take();
                                        continue;
                                    }
                                    job = (Runnable)QueuedThreadPool.access$000(QueuedThreadPool.this).poll(QueuedThreadPool.access$200(QueuedThreadPool.this), TimeUnit.MILLISECONDS);
                                    if (job != null || (size = QueuedThreadPool.access$300(QueuedThreadPool.this).get()) <= QueuedThreadPool.access$400(QueuedThreadPool.this)) continue;
                                    last = QueuedThreadPool.access$500(QueuedThreadPool.this).get();
                                    now = System.currentTimeMillis();
                                    if (last != 0L && now - last <= (long)QueuedThreadPool.access$200(QueuedThreadPool.this) || !(shrink = QueuedThreadPool.access$500(QueuedThreadPool.this).compareAndSet(last, now) != false && QueuedThreadPool.access$300(QueuedThreadPool.this).compareAndSet(size, size - 1) != false)) continue;
                                    var9_8 = null;
                                    QueuedThreadPool.access$100(QueuedThreadPool.this).decrementAndGet();
                                    break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var8_14) {
                                var9_8 = null;
                                QueuedThreadPool.access$100(QueuedThreadPool.this).decrementAndGet();
                                throw var8_14;
                            }
                        }
                        var11_9 = null;
                        if (!shrink) {
                            QueuedThreadPool.access$300(QueuedThreadPool.this).decrementAndGet();
                        }
                        QueuedThreadPool.access$600(QueuedThreadPool.this).remove(Thread.currentThread());
                        return;
lbl-1000:
                        // 1 sources

                        {
                            var9_8 = null;
                            QueuedThreadPool.access$100(QueuedThreadPool.this).decrementAndGet();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Log.ignore(e);
                    var11_11 = null;
                    if (!shrink) {
                        QueuedThreadPool.access$300(QueuedThreadPool.this).decrementAndGet();
                    }
                    QueuedThreadPool.access$600(QueuedThreadPool.this).remove(Thread.currentThread());
                    return;
                }
                catch (Exception e) {
                    Log.warn(e);
                    var11_12 = null;
                    if (!shrink) {
                        QueuedThreadPool.access$300(QueuedThreadPool.this).decrementAndGet();
                    }
                    QueuedThreadPool.access$600(QueuedThreadPool.this).remove(Thread.currentThread());
                    return;
                }
            }
            catch (Throwable var10_15) {
                var11_13 = null;
                if (!shrink) {
                    QueuedThreadPool.access$300(QueuedThreadPool.this).decrementAndGet();
                }
                QueuedThreadPool.access$600(QueuedThreadPool.this).remove(Thread.currentThread());
                throw var10_15;
            }
            var11_10 = null;
            if (!shrink) {
                QueuedThreadPool.access$300(QueuedThreadPool.this).decrementAndGet();
            }
            QueuedThreadPool.access$600(QueuedThreadPool.this).remove(Thread.currentThread());
        }
    };

    public QueuedThreadPool() {
        this._name = "qtp" + super.hashCode();
    }

    public QueuedThreadPool(int maxThreads) {
        this();
        this.setMaxThreads(maxThreads);
    }

    public QueuedThreadPool(BlockingQueue<Runnable> jobQ) {
        this();
        this._jobs = jobQ;
        this._jobs.clear();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._threadsStarted.set(0);
        if (this._jobs == null) {
            this._jobs = this._maxQueued > 0 ? new ArrayBlockingQueue(this._maxQueued) : new BlockingArrayQueue(this._minThreads, this._minThreads);
        }
        int threads = this._threadsStarted.get();
        while (this.isRunning() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        long start = System.currentTimeMillis();
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)(this._maxStopTime / 2)) {
            Thread.sleep(1L);
        }
        this._jobs.clear();
        Runnable noop = new Runnable(){

            public void run() {
            }
        };
        int i = this._threadsIdle.get();
        while (i-- > 0) {
            this._jobs.offer(noop);
        }
        Thread.yield();
        if (this._threadsStarted.get() > 0) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        while (this._threadsStarted.get() > 0 && System.currentTimeMillis() - start < (long)this._maxStopTime) {
            Thread.sleep(1L);
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxStopTimeMs(int stopTimeMs) {
        this._maxStopTime = stopTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        int threads = this._threadsStarted.get();
        while (this.isStarted() && threads < this._minThreads) {
            this.startThread(threads);
            threads = this._threadsStarted.get();
        }
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    public int getMaxQueued() {
        return this._maxQueued;
    }

    public void setMaxQueued(int max) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._maxQueued = max;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTime;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    @Override
    public boolean dispatch(Runnable job) {
        if (this.isRunning()) {
            int jobQ = this._jobs.size();
            int idle = this.getIdleThreads();
            if (this._jobs.offer(job)) {
                int threads;
                if ((idle == 0 || jobQ > idle) && (threads = this._threadsStarted.get()) < this._maxThreads) {
                    this.startThread(threads);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute(Runnable job) {
        if (!this.dispatch(job)) {
            throw new RejectedExecutionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    @Override
    public int getThreads() {
        return this._threadsStarted.get();
    }

    @Override
    public int getIdleThreads() {
        return this._threadsIdle.get();
    }

    @Override
    public boolean isLowOnThreads() {
        return this._threadsStarted.get() == this._maxThreads && this._jobs.size() > this._threadsIdle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startThread(int threads) {
        boolean started;
        block4: {
            int next = threads + 1;
            if (!this._threadsStarted.compareAndSet(threads, next)) {
                return false;
            }
            started = false;
            try {
                Thread thread = this.newThread(this._runnable);
                thread.setDaemon(this._daemon);
                thread.setPriority(this._priority);
                thread.setName(this._name + "-" + thread.getId());
                this._threads.add(thread);
                thread.start();
                started = true;
                Object var6_5 = null;
                if (started) break block4;
                this._threadsStarted.decrementAndGet();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!started) {
                    this._threadsStarted.decrementAndGet();
                }
                throw throwable;
            }
            {
            }
        }
        return started;
    }

    protected Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    public String toString() {
        return this._name + "{" + this.getMinThreads() + "<=" + this.getIdleThreads() + "<=" + this.getThreads() + "/" + this.getMaxThreads() + "," + (this._jobs == null ? -1 : this._jobs.size()) + "}";
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        for (Thread thread : this._threads) {
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ").append((Object)thread.getState()).append(":\n");
            for (StackTraceElement element : thread.getStackTrace()) {
                buf.append("  at ").append(element.toString()).append('\n');
            }
        }
        return buf.toString();
    }

    public boolean stopThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.stop();
            return true;
        }
        return false;
    }

    public boolean interruptThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    public String dumpThread(long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ").append((Object)thread.getState()).append(":\n");
            for (StackTraceElement element : thread.getStackTrace()) {
                buf.append("  at ").append(element.toString()).append('\n');
            }
            return buf.toString();
        }
        return null;
    }

    static /* synthetic */ BlockingQueue access$000(QueuedThreadPool x0) {
        return x0._jobs;
    }

    static /* synthetic */ AtomicInteger access$100(QueuedThreadPool x0) {
        return x0._threadsIdle;
    }

    static /* synthetic */ int access$200(QueuedThreadPool x0) {
        return x0._maxIdleTimeMs;
    }

    static /* synthetic */ AtomicInteger access$300(QueuedThreadPool x0) {
        return x0._threadsStarted;
    }

    static /* synthetic */ int access$400(QueuedThreadPool x0) {
        return x0._minThreads;
    }

    static /* synthetic */ AtomicLong access$500(QueuedThreadPool x0) {
        return x0._lastShrink;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$600(QueuedThreadPool x0) {
        return x0._threads;
    }
}

