/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;

public abstract class ExecutorCallback<C>
implements Callback<C> {
    private final ForkInvoker<C> _invoker;
    private final Executor _executor;

    public ExecutorCallback(Executor executor) {
        this(executor, 4);
    }

    public ExecutorCallback(Executor executor, int maxRecursion) {
        this._executor = executor;
        this._invoker = new ExecutorCallbackInvoker(maxRecursion);
    }

    @Override
    public final void completed(C context) {
        if (this.alwaysDispatchCompletion()) {
            this._invoker.fork(context);
        } else {
            this._invoker.invoke(context);
        }
    }

    protected abstract void onCompleted(C var1);

    @Override
    public final void failed(final C context, final Throwable x) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ExecutorCallback.this.onFailed(context, x);
            }

            public String toString() {
                return String.format("ExecutorCallback@%x{%s,%s}", this.hashCode(), context, x);
            }
        };
        if (this._executor == null) {
            new Thread(runnable).start();
        } else {
            this._executor.execute(runnable);
        }
    }

    protected void onFailed(C context, Throwable x) {
    }

    protected boolean alwaysDispatchCompletion() {
        return this._executor != null;
    }

    public String toString() {
        return String.format("%s@%x", this.getClass(), this.hashCode());
    }

    private class ExecutorCallbackInvoker
    extends ForkInvoker<C>
    implements Runnable {
        private ExecutorCallbackInvoker(int maxInvocations) {
            super(maxInvocations);
        }

        @Override
        public void fork(final C context) {
            ExecutorCallback.this._executor.execute(context == null ? this : new Runnable(){

                @Override
                public void run() {
                    ExecutorCallbackInvoker.this.call(context);
                }

                public String toString() {
                    return String.format("ExecutorCallback@%x{%s}", this.hashCode(), context);
                }
            });
        }

        @Override
        public void call(C context) {
            ExecutorCallback.this.onCompleted(context);
        }

        @Override
        public void run() {
            this.call((C)null);
        }
    }
}

