/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;

public class FutureCallback<C>
implements Future<C>,
Callback<C> {
    private final AtomicReference<State> _state = new AtomicReference<State>(State.NOT_DONE);
    private CountDownLatch _done = new CountDownLatch(1);
    private Throwable _cause;
    private C _context;
    private boolean _completed;

    public FutureCallback() {
    }

    public FutureCallback(C ctx) {
        this._state.set(State.DONE);
        this._context = ctx;
        this._completed = true;
        this._done.countDown();
    }

    public FutureCallback(C ctx, Throwable failed) {
        this._state.set(State.DONE);
        this._context = ctx;
        this._cause = failed;
        this._done.countDown();
    }

    @Override
    public void completed(C context) {
        if (this._state.compareAndSet(State.NOT_DONE, State.DOING)) {
            this._context = context;
            this._completed = true;
            if (this._state.compareAndSet(State.DOING, State.DONE)) {
                this._done.countDown();
                return;
            }
        } else if (!this.isCancelled()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void failed(C context, Throwable cause) {
        if (this._state.compareAndSet(State.NOT_DONE, State.DOING)) {
            this._context = context;
            this._cause = cause;
            if (this._state.compareAndSet(State.DOING, State.DONE)) {
                this._done.countDown();
                return;
            }
        } else if (!this.isCancelled()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.failed(null, new CancellationException());
        return false;
    }

    @Override
    public boolean isCancelled() {
        return State.DONE.equals((Object)this._state.get()) && this._cause instanceof CancellationException;
    }

    @Override
    public boolean isDone() {
        return State.DONE.equals((Object)this._state.get());
    }

    @Override
    public C get() throws InterruptedException, ExecutionException {
        this._done.await();
        if (this._completed) {
            return this._context;
        }
        if (this._cause instanceof CancellationException) {
            throw (CancellationException)new CancellationException().initCause(this._cause);
        }
        throw new ExecutionException(this._cause);
    }

    @Override
    public C get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this._done.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this._completed) {
            return this._context;
        }
        if (this._cause instanceof TimeoutException) {
            throw (TimeoutException)this._cause;
        }
        if (this._cause instanceof CancellationException) {
            throw (CancellationException)new CancellationException().initCause(this._cause);
        }
        throw new ExecutionException(this._cause);
    }

    public static void rethrow(ExecutionException e) throws IOException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }

    public String toString() {
        return String.format("FutureCallback@%x{%s,%b,%s}", this.hashCode(), this._state, this._completed, this._context);
    }

    private static enum State {
        NOT_DONE,
        DOING,
        DONE;

    }
}

