/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimerScheduler
extends AbstractLifeCycle
implements Scheduler {
    Timer _timer;
    final String _name;

    public TimerScheduler() {
        this(null);
    }

    public TimerScheduler(String name) {
        this._name = name;
    }

    @Override
    protected void doStart() throws Exception {
        this._timer = this._name == null ? new Timer() : new Timer(this._name);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._timer.cancel();
        super.doStop();
        this._timer = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit units) {
        Timer timer = this._timer;
        if (timer != null) {
            SimpleTask t = new SimpleTask(task);
            this._timer.schedule((TimerTask)t, units.toMillis(delay));
            return t;
        }
        throw new IllegalStateException("STOPPED: " + this);
    }

    private static class SimpleTask
    extends TimerTask
    implements Scheduler.Task {
        private final Runnable _task;

        SimpleTask(Runnable runnable) {
            this._task = runnable;
        }

        @Override
        public void run() {
            this._task.run();
        }
    }
}

