/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="A thread pool with no max bound by default")
public class QueuedThreadPool
extends AbstractLifeCycle
implements ThreadPool.SizedThreadPool,
Dumpable {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private final AtomicInteger _threadsStarted = new AtomicInteger();
    private final AtomicInteger _threadsIdle = new AtomicInteger();
    private final AtomicLong _lastShrink = new AtomicLong();
    private final ConcurrentLinkedQueue<Thread> _threads = new ConcurrentLinkedQueue();
    private final Object _joinLock = new Object();
    private BlockingQueue<Runnable> _jobs;
    private String _name;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads;
    private int _minThreads;
    private int _maxQueued = -1;
    private int _priority = 5;
    private boolean _daemon = false;
    private boolean _detailedDump = false;
    private Runnable _runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shrink = false;
            try {
                Runnable job = (Runnable)QueuedThreadPool.this._jobs.poll();
                if (job != null && QueuedThreadPool.this._threadsIdle.get() == 0) {
                    QueuedThreadPool.this.startThreads(1);
                }
                while (QueuedThreadPool.this.isRunning()) {
                    while (job != null && QueuedThreadPool.this.isRunning()) {
                        QueuedThreadPool.this.runJob(job);
                        job = (Runnable)QueuedThreadPool.this._jobs.poll();
                    }
                    try {
                        QueuedThreadPool.this._threadsIdle.incrementAndGet();
                        while (QueuedThreadPool.this.isRunning() && job == null) {
                            if (QueuedThreadPool.this._maxIdleTimeMs <= 0) {
                                job = (Runnable)QueuedThreadPool.this._jobs.take();
                                continue;
                            }
                            int size = QueuedThreadPool.this._threadsStarted.get();
                            if (size > QueuedThreadPool.this._minThreads) {
                                long last = QueuedThreadPool.this._lastShrink.get();
                                long now = System.currentTimeMillis();
                                if (last == 0L || now - last > (long)QueuedThreadPool.this._maxIdleTimeMs) {
                                    boolean bl = shrink = QueuedThreadPool.this._lastShrink.compareAndSet(last, now) && QueuedThreadPool.this._threadsStarted.compareAndSet(size, size - 1);
                                    if (shrink) {
                                        return;
                                    }
                                }
                            }
                            job = QueuedThreadPool.this.idleJobPoll();
                        }
                    }
                    finally {
                        if (QueuedThreadPool.this._threadsIdle.decrementAndGet() != 0) continue;
                        QueuedThreadPool.this.startThreads(1);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.ignore(e);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
            finally {
                if (!shrink) {
                    QueuedThreadPool.this._threadsStarted.decrementAndGet();
                }
                QueuedThreadPool.this._threads.remove(Thread.currentThread());
            }
        }
    };

    public QueuedThreadPool() {
        this(200, 8, 60000);
    }

    public QueuedThreadPool(int maxThreads) {
        this(maxThreads, 8, 60000);
    }

    public QueuedThreadPool(int maxThreads, int minThreads) {
        this(maxThreads, minThreads, 60000);
    }

    public QueuedThreadPool(int maxThreads, int minThreads, int maxIdleTimeMs) {
        this._name = "qtp" + super.hashCode();
        this.setMinThreads(minThreads);
        this.setMaxThreads(maxThreads);
        this.setMaxIdleTimeMs(maxIdleTimeMs);
        this.setStopTimeout(5000L);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._threadsStarted.set(0);
        if (this._jobs == null) {
            int maxQueued = this.getMaxQueued();
            this._jobs = (BlockingQueue)((Object)(maxQueued > 0 ? new ArrayBlockingQueue(maxQueued) : new BlockingArrayQueue(this._minThreads, this._minThreads)));
        }
        this.startThreads(this._minThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        long canwait;
        super.doStop();
        long timeout = this.getStopTimeout();
        BlockingQueue<Runnable> jobs = this.getQueue();
        if (timeout <= 0L) {
            jobs.clear();
        }
        Runnable noop = new Runnable(){

            @Override
            public void run() {
            }
        };
        int i = this._threadsStarted.get();
        while (i-- > 0) {
            jobs.offer(noop);
        }
        long stopby = System.currentTimeMillis() + timeout / 2L;
        for (Thread thread : this._threads) {
            canwait = stopby - System.currentTimeMillis();
            if (canwait <= 0L) continue;
            thread.join(canwait);
        }
        if (this._threadsStarted.get() > 0) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        stopby = System.currentTimeMillis() + timeout / 2L;
        for (Thread thread : this._threads) {
            canwait = stopby - System.currentTimeMillis();
            if (canwait <= 0L) continue;
            thread.join(canwait);
        }
        Thread.yield();
        int size = this._threads.size();
        if (size > 0) {
            LOG.warn("{} threads could not be stopped", size);
            if (size <= Runtime.getRuntime().availableProcessors() || LOG.isDebugEnabled()) {
                for (Thread unstopped : this._threads) {
                    StringBuilder dmp = new StringBuilder();
                    for (StackTraceElement element : unstopped.getStackTrace()) {
                        dmp.append(StringUtil.__LINE_SEPARATOR).append("\tat ").append(element);
                    }
                    LOG.warn("Couldn't stop {}{}", unstopped, dmp.toString());
                }
            }
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    @Override
    public void setMaxThreads(int maxThreads) {
        this._maxThreads = maxThreads;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    @Override
    public void setMinThreads(int minThreads) {
        this._minThreads = minThreads;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        int threads = this._threadsStarted.get();
        if (this.isStarted() && threads < this._minThreads) {
            this.startThreads(this._minThreads - threads);
        }
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    @ManagedAttribute(value="maximum queue size")
    public int getMaxQueued() {
        return this._maxQueued;
    }

    public void setMaxQueued(int max) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._maxQueued = max;
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._maxThreads;
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    @ManagedAttribute(value="priority of threads in the pool")
    public int getThreadsPriority() {
        return this._priority;
    }

    @ManagedAttribute(value="thead pool using a daemon thread")
    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    @Override
    public boolean dispatch(Runnable job) {
        LOG.debug("{} dispatched {}", this, job);
        if (this.isRunning()) {
            return this._jobs.offer(job);
        }
        return false;
    }

    @Override
    public void execute(Runnable job) {
        if (!this.dispatch(job)) {
            LOG.warn("{} rejected {}", this, job);
            throw new RejectedExecutionException(job.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    @Override
    @ManagedAttribute(value="total number of threads currently in the pool")
    public int getThreads() {
        return this._threadsStarted.get();
    }

    @Override
    @ManagedAttribute(value="total number of idle threads in the pool")
    public int getIdleThreads() {
        return this._threadsIdle.get();
    }

    @Override
    @ManagedAttribute(value="True if the pools is at maxThreads and there are not idle threads than queued jobs")
    public boolean isLowOnThreads() {
        return this._threadsStarted.get() == this._maxThreads && this._jobs.size() >= this._threadsIdle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startThreads(int threadsToStart) {
        while (threadsToStart > 0) {
            int threads = this._threadsStarted.get();
            if (threads >= this._maxThreads) {
                return false;
            }
            if (!this._threadsStarted.compareAndSet(threads, threads + 1)) continue;
            boolean started = false;
            try {
                Thread thread = this.newThread(this._runnable);
                thread.setDaemon(this.isDaemon());
                thread.setPriority(this.getThreadsPriority());
                thread.setName(this._name + "-" + thread.getId());
                this._threads.add(thread);
                thread.start();
                started = true;
            }
            finally {
                if (!started) {
                    this._threadsStarted.decrementAndGet();
                }
            }
            if (!started) continue;
            --threadsToStart;
        }
        return true;
    }

    protected Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    @Override
    @ManagedOperation(value="dump thread state")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> dump = new ArrayList<Object>(this.getMaxThreads());
        for (final Thread thread : this._threads) {
            final StackTraceElement[] trace = thread.getStackTrace();
            boolean inIdleJobPoll = false;
            for (StackTraceElement t : trace) {
                if (!"idleJobPoll".equals(t.getMethodName())) continue;
                inIdleJobPoll = true;
                break;
            }
            final boolean idle = inIdleJobPoll;
            if (this.isDetailedDump()) {
                dump.add(new Dumpable(){

                    @Override
                    public void dump(Appendable out, String indent) throws IOException {
                        out.append(String.valueOf(thread.getId())).append(' ').append(thread.getName()).append(' ').append(thread.getState().toString()).append(idle ? " IDLE" : "").append('\n');
                        if (!idle) {
                            ContainerLifeCycle.dump(out, indent, Arrays.asList(trace));
                        }
                    }

                    @Override
                    public String dump() {
                        return null;
                    }
                });
                continue;
            }
            dump.add(thread.getId() + " " + thread.getName() + " " + (Object)((Object)thread.getState()) + " @ " + (trace.length > 0 ? trace[0] : "???") + (idle ? " IDLE" : ""));
        }
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, dump);
    }

    public String toString() {
        return String.format("%s{%s,%d<=%d<=%d,i=%d,q=%d}", this._name, this.getState(), this.getMinThreads(), this.getThreads(), this.getMaxThreads(), this.getIdleThreads(), this._jobs == null ? -1 : this._jobs.size());
    }

    private Runnable idleJobPoll() throws InterruptedException {
        return this._jobs.poll(this._maxIdleTimeMs, TimeUnit.MILLISECONDS);
    }

    protected void runJob(Runnable job) {
        job.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    @ManagedOperation(value="interrupt a pool thread")
    public boolean interruptThread(@Name(value="id") long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    @ManagedOperation(value="dump a pool thread stack")
    public String dumpThread(@Name(value="id") long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ").append((Object)thread.getState()).append(":\n");
            for (StackTraceElement element : thread.getStackTrace()) {
                buf.append("  at ").append(element.toString()).append('\n');
            }
            return buf.toString();
        }
        return null;
    }
}

