/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyWebXmlConfiguration
implements Configuration {
    private WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureWebApp() throws Exception {
        Resource web_inf;
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cannot configure webapp after it is started");
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Configuring web-jetty.xml");
        }
        if ((web_inf = this.getWebAppContext().getWebInf()) != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty6-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath("jetty-web.xml");
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                String[] old_server_classes = this._context.getServerClasses();
                try {
                    this._context.setServerClasses(null);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Configure: " + jetty));
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure((Object)this.getWebAppContext());
                }
                finally {
                    if (this._context.getServerClasses() == null) {
                        this._context.setServerClasses(old_server_classes);
                    }
                }
            }
        }
    }

    public void deconfigureWebApp() throws Exception {
    }
}

