/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class FragmentConfiguration
implements Configuration {
    public static final String FRAGMENT_RESOURCES = "org.eclipse.jetty.webFragments";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        MetaData metaData = (MetaData)context.getAttribute("org.eclipse.jetty.metaData");
        if (metaData == null) {
            throw new IllegalStateException("No metadata");
        }
        this.findWebFragments(context, metaData);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        MetaData metaData = (MetaData)context.getAttribute("org.eclipse.jetty.metaData");
        if (metaData == null) {
            throw new IllegalStateException("No metadata");
        }
        metaData.orderFragments();
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void findWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        List frags = (List)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource frag : frags) {
                metaData.addFragment(frag, Resource.newResource((String)("jar:" + frag.getURL() + "!/META-INF/web-fragment.xml")));
            }
        }
    }
}

