/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.xml.XmlParser;

public abstract class IterativeDescriptorProcessor
implements DescriptorProcessor {
    public static final Class[] __signature = new Class[]{Descriptor.class, XmlParser.Node.class};
    protected Map<String, Method> _visitors = new HashMap<String, Method>();

    public abstract void start(Descriptor var1);

    public abstract void end(Descriptor var1);

    public void registerVisitor(String nodeName, Method m) {
        this._visitors.put(nodeName, m);
    }

    @Override
    public void process(Descriptor descriptor) throws Exception {
        if (descriptor == null) {
            return;
        }
        this.start(descriptor);
        XmlParser.Node root = descriptor.getRoot();
        Iterator iter = root.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            this.visit(descriptor, node);
        }
        this.end(descriptor);
    }

    protected void visit(Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getTag();
        Method m = this._visitors.get(name);
        if (m != null) {
            m.invoke((Object)this, descriptor, node);
        }
    }
}

