/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class ClasspathPattern
extends AbstractSet<String> {
    private static final Logger LOG = Log.getLogger(ClasspathPattern.class);
    Map<String, Entry> _entries = new HashMap<String, Entry>();
    Set<String> _classes = new HashSet<String>();
    IncludeExcludeSet<Entry, String> _patterns = new IncludeExcludeSet(ByPackageOrName.class);
    IncludeExcludeSet<File, Path> _locations = new IncludeExcludeSet(ByLocation.class);

    public ClasspathPattern() {
    }

    public ClasspathPattern(String[] patterns) {
        this.setAll(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.add(pattern);
    }

    public boolean include(String name) {
        if (name == null) {
            return false;
        }
        return this.add(new Entry(name, true));
    }

    public boolean include(String ... name) {
        boolean added = false;
        for (String n : name) {
            if (n == null) continue;
            added = this.add(new Entry(n, true)) || added;
        }
        return added;
    }

    public boolean exclude(String name) {
        if (name == null) {
            return false;
        }
        return this.add(new Entry(name, false));
    }

    public boolean exclude(String ... name) {
        boolean added = false;
        for (String n : name) {
            if (n == null) continue;
            added = this.add(new Entry(n, false)) || added;
        }
        return added;
    }

    @Override
    public boolean add(String pattern) {
        if (pattern == null) {
            return false;
        }
        return this.add(new Entry(pattern));
    }

    @Override
    public boolean add(String ... pattern) {
        boolean added = false;
        for (String p : pattern) {
            if (p == null) continue;
            added = this.add(new Entry(p)) || added;
        }
        return added;
    }

    @Override
    protected boolean add(Entry entry) {
        if (this._entries.containsKey(entry.getPattern())) {
            return false;
        }
        this._entries.put(entry.getPattern(), entry);
        if (entry.isLocation()) {
            try {
                File file = Resource.newResource((String)entry.getName()).getFile().getAbsoluteFile().getCanonicalFile();
                if (entry.isInclusive()) {
                    this._locations.include((Object)file);
                }
                this._locations.exclude((Object)file);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (entry.isInclusive()) {
            this._patterns.include((Object)entry);
        } else {
            this._patterns.exclude((Object)entry);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String pattern = (String)o;
        Entry entry = this._entries.remove(pattern);
        if (entry == null) {
            return false;
        }
        ArrayList<Entry> saved = new ArrayList<Entry>(this._entries.values());
        this.clear();
        for (Entry e : saved) {
            this.add(e);
        }
        return true;
    }

    @Override
    public void clear() {
        this._entries.clear();
        this._patterns.clear();
        this._locations.clear();
    }

    @Override
    public Iterator<String> iterator() {
        return this._entries.keySet().iterator();
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    private void setAll(String[] classes) {
        this._entries.clear();
        this.addAll(classes);
    }

    private void addAll(String[] classes) {
        if (classes != null) {
            this.addAll(Arrays.asList(classes));
        }
    }

    public String[] getPatterns() {
        return this.toArray(new String[this._entries.size()]);
    }

    public boolean match(String name) {
        return this._patterns.test((Object)name);
    }

    public boolean match(Class<?> clazz) {
        try {
            Resource resource = TypeUtil.getLoadedFrom(clazz);
            Path path = resource.getFile().toPath();
            Boolean byName = this._patterns.isIncludedAndNotExcluded((Object)clazz.getName());
            Boolean byLocation = this._locations.isIncludedAndNotExcluded((Object)path);
            boolean included = byName == Boolean.TRUE || byLocation == Boolean.TRUE || byName == null && !this._patterns.hasIncludes() && byLocation == null && !this._locations.hasIncludes();
            boolean excluded = byName == Boolean.FALSE || byLocation == Boolean.FALSE;
            return included && !excluded;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public boolean match(String name, URL url) {
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        name = name.replace("/", ".");
        Boolean byName = this._patterns.isIncludedAndNotExcluded((Object)name);
        Boolean byLocation = null;
        try {
            Resource resource = Resource.newResource((URI)URIUtil.getJarSource((URI)url.toURI()));
            File file = resource.getFile();
            byLocation = this._locations.isIncludedAndNotExcluded((Object)file.toPath());
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        boolean included = byName == Boolean.TRUE || byLocation == Boolean.TRUE || byName == null && !this._patterns.hasIncludes() && byLocation == null && !this._locations.hasIncludes();
        boolean excluded = byName == Boolean.FALSE || byLocation == Boolean.FALSE;
        return included && !excluded;
    }

    public static class ByLocation
    extends HashSet<File>
    implements Predicate<Path> {
        @Override
        public boolean test(Path path) {
            for (File file : this) {
                if (!(file.isDirectory() ? path.startsWith(file.toPath()) : path.equals(file.toPath()))) continue;
                return true;
            }
            return false;
        }
    }

    public static class ByPackageOrName
    extends AbstractSet<Entry>
    implements Predicate<String> {
        private final ByName _byName = new ByName();
        private final ByPackage _byPackage = new ByPackage();

        @Override
        public boolean test(String name) {
            return this._byPackage.test(name) || this._byName.test(name);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._byPackage.iterator();
        }

        @Override
        public int size() {
            return this._byPackage.size();
        }

        @Override
        public boolean add(Entry e) {
            if (e.isLocation()) {
                throw new IllegalArgumentException();
            }
            if (e.isPackage()) {
                return this._byPackage.add(e);
            }
            boolean added = this._byPackage.add(e);
            added = this._byName.add(e) || added;
            return added;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            boolean removed = this._byPackage.remove(o);
            if (!((Entry)o).isPackage()) {
                removed = this._byName.remove(o) || removed;
            }
            return removed;
        }

        @Override
        public void clear() {
            this._byPackage.clear();
            this._byName.clear();
        }
    }

    public static class ByName
    extends HashSet<Entry>
    implements Predicate<String> {
        private final Map<String, Entry> _entries = new HashMap<String, Entry>();

        @Override
        public boolean test(String name) {
            return this._entries.containsKey(name);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._entries.values().iterator();
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean add(Entry entry) {
            if (!entry.isClassName()) {
                throw new IllegalArgumentException(entry.toString());
            }
            return this._entries.put(entry.getName(), entry) == null;
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof Entry)) {
                return false;
            }
            return this._entries.remove(((Entry)entry).getName()) != null;
        }
    }

    public static class ByPackage
    extends AbstractSet<Entry>
    implements Predicate<String> {
        private final ArrayTernaryTrie.Growing<Entry> _entries = new ArrayTernaryTrie.Growing(false, 512, 512);

        @Override
        public boolean test(String name) {
            return this._entries.getBest(name) != null;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._entries.keySet().stream().map(k -> (Entry)this._entries.get(k)).iterator();
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean isEmpty() {
            return this._entries.isEmpty();
        }

        @Override
        public boolean add(Entry entry) {
            String name = entry.getName();
            if (entry.isClassName()) {
                name = name + "$";
            } else {
                if (entry.isLocation()) {
                    throw new IllegalArgumentException(entry.toString());
                }
                if (".".equals(name)) {
                    name = "";
                }
            }
            if (this._entries.get(name) != null) {
                return false;
            }
            this._entries.put(name, (Object)entry);
            return true;
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof Entry)) {
                return false;
            }
            return this._entries.remove(((Entry)entry).getName()) != null;
        }

        @Override
        public void clear() {
            this._entries.clear();
        }
    }

    private static class Entry {
        private final String _pattern;
        private final String _name;
        private final boolean _inclusive;
        private final Type _type;

        Entry(String pattern) {
            this._pattern = pattern;
            this._inclusive = !pattern.startsWith("-");
            String string = this._name = this._inclusive ? pattern : pattern.substring(1).trim();
            this._type = this._name.startsWith("file:") ? Type.LOCATION : (this._name.endsWith(".") ? Type.PACKAGE : Type.CLASSNAME);
        }

        Entry(String name, boolean include) {
            this._pattern = include ? name : "-" + name;
            this._inclusive = include;
            this._name = name;
            this._type = this._name.startsWith("file:") ? Type.LOCATION : (this._name.endsWith(".") ? Type.PACKAGE : Type.CLASSNAME);
        }

        public String getPattern() {
            return this._pattern;
        }

        public boolean isPackage() {
            return this._type == Type.PACKAGE;
        }

        public boolean isClassName() {
            return this._type == Type.CLASSNAME;
        }

        public boolean isLocation() {
            return this._type == Type.LOCATION;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this._pattern;
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Entry && this._pattern.equals(((Entry)o)._pattern);
        }

        public boolean isInclusive() {
            return this._inclusive;
        }
    }

    static enum Type {
        PACKAGE,
        CLASSNAME,
        LOCATION;

    }
}

