/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.eclipse.jetty.websocket.WebSocketConnection;

public class WebSocketClient {
    private static final Logger __log = Log.getLogger((String)WebSocketClient.class.getName());
    private final WebSocketClientFactory _factory;
    private final Map<String, String> _cookies = new ConcurrentHashMap<String, String>();
    private final List<String> _extensions = new CopyOnWriteArrayList<String>();
    private String _origin;
    private String _protocol;
    private int _maxIdleTime = -1;
    private int _maxTextMessageSize = 16384;
    private int _maxBinaryMessageSize = -1;
    private MaskGen _maskGen;
    private SocketAddress _bindAddress;

    @Deprecated
    public WebSocketClient() throws Exception {
        this._factory = new WebSocketClientFactory();
        this._factory.start();
        this._maskGen = this._factory.getMaskGen();
    }

    public WebSocketClient(WebSocketClientFactory factory) {
        this._factory = factory;
        this._maskGen = this._factory.getMaskGen();
    }

    public WebSocketClientFactory getFactory() {
        return this._factory;
    }

    public SocketAddress getBindAddress() {
        return this._bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this._bindAddress = bindAddress;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getOrigin() {
        return this._origin;
    }

    public void setOrigin(String origin) {
        this._origin = origin;
    }

    public Map<String, String> getCookies() {
        return this._cookies;
    }

    public List<String> getExtensions() {
        return this._extensions;
    }

    public MaskGen getMaskGen() {
        return this._maskGen;
    }

    public void setMaskGen(MaskGen maskGen) {
        this._maskGen = maskGen;
    }

    public int getMaxTextMessageSize() {
        return this._maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this._maxTextMessageSize = maxTextMessageSize;
    }

    public int getMaxBinaryMessageSize() {
        return this._maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this._maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public WebSocket.Connection open(URI uri, WebSocket websocket, long maxConnectTime, TimeUnit units) throws IOException, InterruptedException, TimeoutException {
        try {
            return this.open(uri, websocket).get(maxConnectTime, units);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Future<WebSocket.Connection> open(URI uri, WebSocket websocket) throws IOException {
        if (!this._factory.isStarted()) {
            throw new IllegalStateException("Factory !started");
        }
        __log.debug("Connecting to: {}", new Object[]{uri});
        InetSocketAddress address = WebSocketClient.toSocketAddress(uri);
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            if (this._bindAddress != null) {
                channel.socket().bind(this._bindAddress);
            }
            channel.socket().setTcpNoDelay(true);
            WebSocketFuture holder = new WebSocketFuture(websocket, uri, this, channel);
            channel.configureBlocking(false);
            channel.connect(address);
            this._factory.getSelectorManager().register(channel, (Object)holder);
            return holder;
        }
        catch (RuntimeException e) {
            IO.close((Closeable)channel);
            throw e;
        }
        catch (IOException e) {
            IO.close((Closeable)channel);
            throw e;
        }
    }

    public static InetSocketAddress toSocketAddress(URI uri) {
        String scheme = uri.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Bad WebSocket scheme: " + scheme);
        }
        int port = uri.getPort();
        if (port == 0) {
            throw new IllegalArgumentException("Bad WebSocket port: " + port);
        }
        if (port < 0) {
            port = "ws".equals(scheme) ? 80 : 443;
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    static class WebSocketFuture
    implements Future<WebSocket.Connection> {
        final WebSocket _websocket;
        final URI _uri;
        final WebSocketClient _client;
        final CountDownLatch _done = new CountDownLatch(1);
        ByteChannel _channel;
        WebSocketConnection _connection;
        Throwable _exception;

        private WebSocketFuture(WebSocket websocket, URI uri, WebSocketClient client, ByteChannel channel) {
            this._websocket = websocket;
            this._uri = uri;
            this._client = client;
            this._channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnection(WebSocketConnection connection) {
            try {
                WebSocketConnection con;
                this._client.getFactory().addConnection(connection);
                connection.getConnection().setMaxTextMessageSize(this._client.getMaxTextMessageSize());
                connection.getConnection().setMaxBinaryMessageSize(this._client.getMaxBinaryMessageSize());
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        this._connection = connection;
                    }
                    con = this._connection;
                }
                if (con != null) {
                    if (this._websocket instanceof WebSocket.OnFrame) {
                        ((WebSocket.OnFrame)this._websocket).onHandshake((WebSocket.FrameConnection)con.getConnection());
                    }
                    this._websocket.onOpen(con.getConnection());
                }
            }
            finally {
                this._done.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handshakeFailed(Throwable ex) {
            try {
                ByteChannel channel = null;
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        channel = this._channel;
                        this._channel = null;
                        this._exception = ex;
                    }
                }
                if (channel != null) {
                    if (ex instanceof ProtocolException) {
                        this.closeChannel(channel, 1002, ex.getMessage());
                    } else {
                        this.closeChannel(channel, 1006, ex.getMessage());
                    }
                }
            }
            finally {
                this._done.countDown();
            }
        }

        public Map<String, String> getCookies() {
            return this._client.getCookies();
        }

        public String getProtocol() {
            return this._client.getProtocol();
        }

        public WebSocket getWebSocket() {
            return this._websocket;
        }

        public URI getURI() {
            return this._uri;
        }

        public int getMaxIdleTime() {
            return this._client.getMaxIdleTime();
        }

        public String getOrigin() {
            return this._client.getOrigin();
        }

        public MaskGen getMaskGen() {
            return this._client.getMaskGen();
        }

        public String toString() {
            return "[" + this._uri + "," + this._websocket + "]@" + this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                ByteChannel channel = null;
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._connection == null && this._exception == null && this._channel != null) {
                        channel = this._channel;
                        this._channel = null;
                    }
                }
                if (channel != null) {
                    this.closeChannel(channel, 1006, "cancelled");
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this._done.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._channel == null && this._connection == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._connection != null && this._exception == null;
            }
        }

        @Override
        public WebSocket.Connection get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("The universe has ended", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebSocket.Connection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Throwable exception;
            this._done.await(timeout, unit);
            ByteChannel channel = null;
            WebSocket.Connection connection = null;
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                exception = this._exception;
                if (this._connection == null) {
                    exception = this._exception;
                    channel = this._channel;
                    this._channel = null;
                } else {
                    connection = this._connection.getConnection();
                }
            }
            if (channel != null) {
                this.closeChannel(channel, 1006, "timeout");
            }
            if (exception != null) {
                throw new ExecutionException(exception);
            }
            if (connection != null) {
                return connection;
            }
            throw new TimeoutException();
        }

        private void closeChannel(ByteChannel channel, int code, String message) {
            try {
                this._websocket.onClose(code, message);
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
            }
            try {
                channel.close();
            }
            catch (IOException e) {
                __log.debug((Throwable)e);
            }
        }
    }
}

