/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.osgi.boot.AbstractContextProvider;
import org.eclipse.jetty.osgi.boot.BundleProvider;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextProvider
extends AbstractContextProvider
implements BundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContextProvider.class);
    private Map<String, App> _appMap = new HashMap<String, App>();
    private Map<Bundle, List<App>> _bundleMap = new HashMap<Bundle, List<App>>();
    private ServiceRegistration _serviceRegForBundles;
    private BundleTracker _tracker;

    public BundleContextProvider(ServerInstanceWrapper wrapper) {
        super(wrapper);
    }

    protected void doStart() throws Exception {
        this._tracker = new ContextBundleTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), this.getServerInstanceWrapper().getManagedServerName());
        this._tracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", this.getServerInstanceWrapper().getManagedServerName());
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._tracker.close();
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister {}", (Object)this._serviceRegForBundles, (Object)e);
            }
        }
    }

    @Override
    public boolean bundleAdded(Bundle bundle) throws Exception {
        String[] tmp;
        if (bundle == null) {
            return false;
        }
        if ((String)bundle.getHeaders().get("Web-ContextPath") != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BundleContextProvider ignoring bundle {} with {} set", (Object)bundle.getSymbolicName(), (Object)"Web-ContextPath");
            }
            return false;
        }
        String contextFiles = (String)bundle.getHeaders().get("Jetty-ContextFilePath");
        if (contextFiles == null) {
            return false;
        }
        boolean added = false;
        for (String contextFile : tmp = contextFiles.split("[,;]")) {
            String originId = bundle.getSymbolicName() + "-" + bundle.getVersion().toString() + "-" + contextFile;
            AbstractContextProvider.OSGiApp app = new AbstractContextProvider.OSGiApp(this.getDeploymentManager(), this, originId, bundle, contextFile);
            this._appMap.put(originId, app);
            List<App> apps = this._bundleMap.get(bundle);
            if (apps == null) {
                apps = new ArrayList<App>();
                this._bundleMap.put(bundle, apps);
            }
            apps.add(app);
            this.getDeploymentManager().addApp((App)app);
            added = true;
        }
        return added;
    }

    @Override
    public boolean bundleRemoved(Bundle bundle) throws Exception {
        List<App> apps = this._bundleMap.remove(bundle);
        boolean removed = false;
        if (apps != null) {
            for (App app : apps) {
                this._appMap.remove(app.getOriginId());
                this.getDeploymentManager().removeApp(app);
                removed = true;
            }
        }
        return removed;
    }

    public class ContextBundleTracker
    extends BundleTracker {
        protected String _managedServerName;

        public ContextBundleTracker(BundleContext bundleContext, String managedServerName) {
            super(bundleContext, 48, null);
            this._managedServerName = managedServerName;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            try {
                String serverName = (String)bundle.getHeaders().get("managedServerName");
                if ((StringUtil.isBlank((String)serverName) && this._managedServerName.equals("defaultJettyServer") || !StringUtil.isBlank((String)serverName) && serverName.equals(this._managedServerName)) && BundleContextProvider.this.bundleAdded(bundle)) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to add bundle {}", (Object)bundle, (Object)e);
            }
            return null;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            try {
                BundleContextProvider.this.bundleRemoved(bundle);
            }
            catch (Exception e) {
                LOG.warn("Unable to remove bundle {}", (Object)bundle, (Object)e);
            }
        }
    }
}

