/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.AbstractOSGiApp;
import org.eclipse.jetty.osgi.boot.OSGiWebappConstants;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.internal.webapp.OSGiWebappClassLoader;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public abstract class AbstractWebAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG = Log.getLogger(AbstractWebAppProvider.class);
    public static String[] __defaultConfigurations = new String[]{"org.eclipse.jetty.osgi.boot.OSGiWebInfConfiguration", "org.eclipse.jetty.webapp.WebXmlConfiguration", "org.eclipse.jetty.webapp.MetaInfConfiguration", "org.eclipse.jetty.webapp.FragmentConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"};
    private boolean _parentLoaderPriority;
    private String _defaultsDescriptor;
    private boolean _extractWars = true;
    private String _tldBundles;
    private DeploymentManager _deploymentManager;
    private String[] _configurationClasses;
    private ServerInstanceWrapper _serverWrapper;

    public static void setDefaultConfigurations(String[] defaultConfigs) {
        __defaultConfigurations = defaultConfigs;
    }

    public static String[] getDefaultConfigurations() {
        return __defaultConfigurations;
    }

    public AbstractWebAppProvider(ServerInstanceWrapper wrapper) {
        this._serverWrapper = wrapper;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public boolean isExtract() {
        return this._extractWars;
    }

    public void setExtract(boolean extract) {
        this._extractWars = extract;
    }

    public void setTldBundles(String tldBundles) {
        this._tldBundles = tldBundles;
    }

    public String getTldBundles() {
        return this._tldBundles;
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public void setServerInstanceWrapper(ServerInstanceWrapper wrapper) {
        this._serverWrapper = wrapper;
    }

    public ServerInstanceWrapper getServerInstanceWrapper() {
        return this._serverWrapper;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        if (app == null) {
            return null;
        }
        if (!(app instanceof OSGiApp)) {
            throw new IllegalStateException(app + " is not a BundleApp");
        }
        ContextHandler ch = ((OSGiApp)app).createContextHandler();
        return ch;
    }

    public static String getOriginId(Bundle contributor, String path) {
        return contributor.getSymbolicName() + "-" + contributor.getVersion().toString() + (path.startsWith("/") ? path : "/" + path);
    }

    public class OSGiApp
    extends AbstractOSGiApp {
        private String _contextPath;
        private String _webAppPath;
        private WebAppContext _webApp;

        public OSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle, String originId) {
            super(manager, provider, bundle, originId);
        }

        public OSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle, Dictionary properties, String originId) {
            super(manager, provider, bundle, properties, originId);
        }

        public void setWebAppContext(WebAppContext webApp) {
            this._webApp = webApp;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public void setContextPath(String contextPath) {
            this._contextPath = contextPath;
        }

        public String getBundlePath() {
            return this._webAppPath;
        }

        public void setWebAppPath(String path) {
            this._webAppPath = path;
        }

        public ContextHandler createContextHandler() throws Exception {
            if (this._webApp != null) {
                this.configureWebApp();
                return this._webApp;
            }
            this.createWebApp();
            return this._webApp;
        }

        protected void createWebApp() throws Exception {
            this._webApp = this.newWebApp();
            this.configureWebApp();
        }

        protected WebAppContext newWebApp() {
            WebAppContext webApp = new WebAppContext();
            webApp.setAttribute("o.e.j.o.b.watermark", (Object)"o.e.j.o.b.watermark");
            String[] targets = webApp.getProtectedTargets();
            String[] updatedTargets = null;
            if (targets != null) {
                updatedTargets = new String[targets.length + OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
                System.arraycopy(targets, 0, updatedTargets, 0, targets.length);
            } else {
                updatedTargets = new String[OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length];
            }
            System.arraycopy(OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS, 0, updatedTargets, targets.length, OSGiWebappConstants.DEFAULT_PROTECTED_OSGI_TARGETS.length);
            webApp.setProtectedTargets(updatedTargets);
            return webApp;
        }

        public void configureWebApp() throws Exception {
            File defaultWebXml;
            File webXml;
            String tmp;
            Enumeration<URL> urls;
            this._webApp.setContextPath(this._contextPath);
            this._webApp.setAttribute("osgi-bundlecontext", (Object)this._bundle.getBundleContext());
            String overrideBundleInstallLocation = (String)this._properties.get("Jetty-bundleInstall");
            File bundleInstallLocation = overrideBundleInstallLocation == null ? BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(this._bundle) : new File(overrideBundleInstallLocation);
            URL url = null;
            if (this._webAppPath == null || this._webAppPath.length() == 0 || ".".equals(this._webAppPath)) {
                url = bundleInstallLocation.toURI().toURL();
            } else if (this._webAppPath.startsWith("/") || this._webAppPath.startsWith("file:")) {
                url = new File(this._webAppPath).toURI().toURL();
            } else if (bundleInstallLocation != null && bundleInstallLocation.isDirectory()) {
                url = new File(bundleInstallLocation, this._webAppPath).toURI().toURL();
            } else if (bundleInstallLocation != null && (urls = BundleFileLocatorHelperFactory.getFactory().getHelper().findEntries(this._bundle, this._webAppPath)) != null && urls.hasMoreElements()) {
                url = urls.nextElement();
            }
            if (url == null) {
                throw new IllegalArgumentException("Unable to locate " + this._webAppPath + " in " + (bundleInstallLocation != null ? bundleInstallLocation.getAbsolutePath() : "unlocated bundle '" + this._bundle.getSymbolicName() + "'"));
            }
            this._webApp.setWar(BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(url).toString());
            this._webApp.setParentLoaderPriority(AbstractWebAppProvider.this.isParentLoaderPriority());
            this._webApp.setExtractWAR(AbstractWebAppProvider.this.isExtract());
            if (AbstractWebAppProvider.this.getConfigurationClasses() != null) {
                this._webApp.setConfigurationClasses(AbstractWebAppProvider.this.getConfigurationClasses());
            } else {
                this._webApp.setConfigurationClasses(__defaultConfigurations);
            }
            if (AbstractWebAppProvider.this.getDefaultsDescriptor() != null) {
                this._webApp.setDefaultsDescriptor(AbstractWebAppProvider.this.getDefaultsDescriptor());
            }
            if ((tmp = (String)this._properties.get("Jetty-extraClasspath")) != null) {
                this._webApp.setExtraClasspath(tmp);
            }
            if ((tmp = (String)this._properties.get("Jetty-WebXmlFilePath")) != null && tmp.trim().length() != 0 && (webXml = this.getFile(tmp, bundleInstallLocation)) != null && webXml.exists()) {
                this._webApp.setDescriptor(webXml.getAbsolutePath());
            }
            if ((tmp = (String)this._properties.get("Jetty-defaultWebXmlFilePath")) != null && (defaultWebXml = this.getFile(tmp, bundleInstallLocation)) != null && defaultWebXml.exists()) {
                this._webApp.setDefaultsDescriptor(defaultWebXml.getAbsolutePath());
            }
            String requireTldBundles = (String)this._properties.get("Require-TldBundle");
            String pathsToTldBundles = this.getPathsToRequiredBundles(requireTldBundles);
            OSGiWebappClassLoader webAppLoader = new OSGiWebappClassLoader(AbstractWebAppProvider.this._serverWrapper.getParentClassLoaderForWebapps(), this._webApp, this._bundle);
            if (pathsToTldBundles != null) {
                webAppLoader.addClassPath(pathsToTldBundles);
            }
            this._webApp.setClassLoader((ClassLoader)((Object)webAppLoader));
            this.applyMetaInfContextXml();
            this._webApp.setAttribute("Require-TldBundle", (Object)requireTldBundles);
            this._webApp.setAttribute("osgi-bundlecontext", (Object)this._bundle.getBundleContext());
            this._webApp.setAttribute("org.springframework.osgi.web." + BundleContext.class.getName(), (Object)this._bundle.getBundleContext());
            this._webApp.setAttribute("osgi-bundle", (Object)this._bundle);
        }

        protected String getPathsToRequiredBundles(String requireTldBundles) throws Exception {
            String[] symbNames;
            PackageAdmin packageAdmin;
            if (requireTldBundles == null) {
                return null;
            }
            ServiceReference ref = this._bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
            PackageAdmin packageAdmin2 = packageAdmin = ref == null ? null : (PackageAdmin)this._bundle.getBundleContext().getService(ref);
            if (packageAdmin == null) {
                throw new IllegalStateException("Unable to get PackageAdmin reference to locate required Tld bundles");
            }
            StringBuilder paths = new StringBuilder();
            for (String symbName : symbNames = requireTldBundles.split(", ")) {
                Bundle[] bs = packageAdmin.getBundles(symbName, null);
                if (bs == null || bs.length == 0) {
                    throw new IllegalArgumentException("Unable to locate the bundle '" + symbName + "' specified by " + "Require-TldBundle" + " in manifest of " + (this._bundle == null ? "unknown" : this._bundle.getSymbolicName()));
                }
                File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bs[0]);
                if (paths.length() > 0) {
                    paths.append(", ");
                }
                paths.append(f.toURI().toURL().toString());
                LOG.debug("getPathsToRequiredBundles: bundle path=" + bs[0].getLocation() + " uri=" + f.toURI(), new Object[0]);
            }
            return paths.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyMetaInfContextXml() throws Exception {
            if (this._bundle == null) {
                return;
            }
            if (this._webApp == null) {
                return;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            LOG.debug("Context classloader = " + cl, new Object[0]);
            try {
                Thread.currentThread().setContextClassLoader(this._webApp.getClassLoader());
                URL contextXmlUrl = this._bundle.getEntry("/META-INF/jetty-webapp-context.xml");
                if (contextXmlUrl == null) {
                    return;
                }
                LOG.info("Applying " + contextXmlUrl + " to " + this._webApp, new Object[0]);
                XmlConfiguration xmlConfiguration = new XmlConfiguration(contextXmlUrl);
                HashMap<String, Server> properties = new HashMap<String, Server>();
                properties.put("Server", this.getDeploymentManager().getServer());
                xmlConfiguration.getProperties().putAll(properties);
                xmlConfiguration.configure((Object)this._webApp);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        private File getFile(String file, File bundleInstall) {
            if (file == null) {
                return null;
            }
            if (file.startsWith("/") || file.startsWith("file:/")) {
                return new File(file);
            }
            return new File(bundleInstall, file);
        }
    }
}

