/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.bindings.StandardStarter;
import org.eclipse.jetty.deploy.bindings.StandardStopper;
import org.eclipse.jetty.osgi.boot.AbstractContextProvider;
import org.eclipse.jetty.osgi.boot.AbstractWebAppProvider;
import org.eclipse.jetty.osgi.boot.BundleContextProvider;
import org.eclipse.jetty.osgi.boot.BundleWebAppProvider;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.OSGiDeployer;
import org.eclipse.jetty.osgi.boot.OSGiUndeployer;
import org.eclipse.jetty.osgi.boot.ServiceContextProvider;
import org.eclipse.jetty.osgi.boot.ServiceWebAppProvider;
import org.eclipse.jetty.osgi.boot.internal.webapp.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.osgi.boot.internal.webapp.LibExtClassLoaderHelper;
import org.eclipse.jetty.osgi.boot.utils.FakeURLClassLoader;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXParseException;

public class ServerInstanceWrapper {
    public static final String PROPERTY_THIS_JETTY_XML_FOLDER_URL = "this.jetty.xml.parent.folder.url";
    private static Collection<TldBundleDiscoverer> __containerTldBundleDiscoverers = new ArrayList<TldBundleDiscoverer>();
    private static Logger LOG = Log.getLogger((String)ServerInstanceWrapper.class.getName());
    private final String _managedServerName;
    private Server _server;
    private ContextHandlerCollection _ctxtCollection;
    private ClassLoader _commonParentClassLoaderForWebapps;
    private DeploymentManager _deploymentManager;

    public static void addContainerTldBundleDiscoverer(TldBundleDiscoverer tldBundleDiscoverer) {
        __containerTldBundleDiscoverers.add(tldBundleDiscoverer);
    }

    public static Collection<TldBundleDiscoverer> getContainerTldBundleDiscoverers() {
        return __containerTldBundleDiscoverers;
    }

    public ServerInstanceWrapper(String managedServerName) {
        this._managedServerName = managedServerName;
    }

    public String getManagedServerName() {
        return this._managedServerName;
    }

    public ClassLoader getParentClassLoaderForWebapps() {
        return this._commonParentClassLoaderForWebapps;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Server getServer() {
        return this._server;
    }

    public ContextHandlerCollection getContextHandlerCollection() {
        return this._ctxtCollection;
    }

    public void start(Server server, Dictionary props) throws Exception {
        this._server = server;
        ClassLoader contextCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader libExtClassLoader = null;
            String sharedURLs = (String)props.get("managedJettySharedLibFolderUrls");
            List<File> shared = sharedURLs != null ? this.extractFiles(sharedURLs) : null;
            libExtClassLoader = LibExtClassLoaderHelper.createLibExtClassLoader(shared, null, server, JettyBootstrapActivator.class.getClassLoader());
            if (LOG.isDebugEnabled()) {
                LOG.debug("LibExtClassLoader = " + libExtClassLoader, new Object[0]);
            }
            Thread.currentThread().setContextClassLoader(libExtClassLoader);
            this.configure(server, props);
            this.init();
            if (!__containerTldBundleDiscoverers.isEmpty()) {
                HashSet<URL> urls = new HashSet<URL>();
                for (TldBundleDiscoverer d : __containerTldBundleDiscoverers) {
                    URL[] list = d.getUrlsForBundlesWithTlds(this._deploymentManager, BundleFileLocatorHelperFactory.getFactory().getHelper());
                    if (list == null) continue;
                    for (URL u : list) {
                        urls.add(u);
                    }
                }
                this._commonParentClassLoaderForWebapps = new FakeURLClassLoader(libExtClassLoader, urls.toArray(new URL[urls.size()]));
            } else {
                this._commonParentClassLoaderForWebapps = libExtClassLoader;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("common classloader = " + this._commonParentClassLoaderForWebapps, new Object[0]);
            }
            server.start();
        }
        catch (Exception e) {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (Exception x) {
                    LOG.ignore((Throwable)x);
                }
            }
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCl);
        }
    }

    public void stop() {
        try {
            if (this._server.isRunning()) {
                this._server.stop();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private void configure(Server server, Dictionary props) throws Exception {
        List<URL> jettyConfigurations;
        String jettyConfigurationUrls = (String)props.get("jetty.etc.config.urls");
        List<URL> list = jettyConfigurations = jettyConfigurationUrls != null ? this.extractResources(jettyConfigurationUrls) : null;
        if (jettyConfigurations == null || jettyConfigurations.isEmpty()) {
            return;
        }
        Map<String, Object> id_map = new HashMap<String, Server>();
        id_map.put("Server", server);
        id_map.put((String)props.get("managedServerName"), server);
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration en = props.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object value = props.get(key);
            String keyStr = String.valueOf(key);
            String valStr = String.valueOf(value);
            properties.put(keyStr, valStr);
            server.setAttribute(keyStr, (Object)valStr);
        }
        for (URL jettyConfiguration : jettyConfigurations) {
            Resource r;
            InputStream is;
            block10: {
                is = null;
                r = Resource.newResource((URL)jettyConfiguration);
                if (r.exists()) break block10;
                LOG.warn("File does not exist " + r, new Object[0]);
                IO.close((InputStream)is);
                continue;
            }
            try {
                is = r.getInputStream();
                XmlConfiguration config = new XmlConfiguration(is);
                config.getIdMap().putAll(id_map);
                String urlPath = jettyConfiguration.toString();
                int lastSlash = urlPath.lastIndexOf(47);
                if (lastSlash > 4) {
                    urlPath = urlPath.substring(0, lastSlash);
                    HashMap<String, String> properties2 = new HashMap<String, String>(properties);
                    properties2.put(PROPERTY_THIS_JETTY_XML_FOLDER_URL, urlPath);
                    config.getProperties().putAll(properties2);
                } else {
                    config.getProperties().putAll(properties);
                }
                config.configure();
                id_map = config.getIdMap();
            }
            catch (SAXParseException saxparse) {
                try {
                    LOG.warn("Unable to configure the jetty/etc file " + jettyConfiguration, (Throwable)saxparse);
                    throw saxparse;
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((InputStream)is);
        }
    }

    private void init() {
        AbstractContextProvider contextProvider;
        AbstractWebAppProvider webAppProvider;
        this._ctxtCollection = (ContextHandlerCollection)this._server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this._ctxtCollection == null) {
            throw new IllegalStateException("ERROR: No ContextHandlerCollection configured in Server");
        }
        ArrayList<String> providerClassNames = new ArrayList<String>();
        Collection deployers = this._server.getBeans(DeploymentManager.class);
        if (deployers != null && !deployers.isEmpty()) {
            this._deploymentManager = (DeploymentManager)deployers.iterator().next();
            for (AppProvider provider : this._deploymentManager.getAppProviders()) {
                providerClassNames.add(provider.getClass().getName());
            }
        } else {
            this._deploymentManager = new DeploymentManager();
            this._deploymentManager.setContexts(this._ctxtCollection);
            this._server.addBean((Object)this._deploymentManager);
        }
        this._deploymentManager.setUseStandardBindings(false);
        ArrayList<Object> deploymentLifeCycleBindings = new ArrayList<Object>();
        deploymentLifeCycleBindings.add((Object)new OSGiDeployer());
        deploymentLifeCycleBindings.add(new StandardStarter());
        deploymentLifeCycleBindings.add(new StandardStopper());
        deploymentLifeCycleBindings.add((Object)new OSGiUndeployer());
        this._deploymentManager.setLifeCycleBindings(deploymentLifeCycleBindings);
        if (!providerClassNames.contains(BundleWebAppProvider.class.getName())) {
            try {
                webAppProvider = new BundleWebAppProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)webAppProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(ServiceWebAppProvider.class.getName())) {
            try {
                webAppProvider = new ServiceWebAppProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)webAppProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(BundleContextProvider.class.getName())) {
            try {
                contextProvider = new BundleContextProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)contextProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!providerClassNames.contains(ServiceContextProvider.class.getName())) {
            try {
                contextProvider = new ServiceContextProvider(this);
                this._deploymentManager.addAppProvider((AppProvider)contextProvider);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    File getDefaultOSGiContextsHome(File jettyHome) {
        String jettyContextsHome = System.getProperty("jetty.osgi.contexts.home");
        if (jettyContextsHome != null) {
            File contextsHome = new File(jettyContextsHome);
            if (!contextsHome.exists() || !contextsHome.isDirectory()) {
                throw new IllegalArgumentException("the ${jetty.osgi.contexts.home} '" + jettyContextsHome + " must exist and be a folder");
            }
            return contextsHome;
        }
        return new File(jettyHome, "/contexts");
    }

    private List<URL> extractResources(String propertyValue) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",;", false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            try {
                urls.add(BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(new URL(tok)));
            }
            catch (Throwable mfe) {
                LOG.warn(mfe);
            }
        }
        return urls;
    }

    private List<File> extractFiles(String propertyValue) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",;", false);
        ArrayList<File> files = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            try {
                Resource res;
                File folder;
                URL url = new URL(tok);
                url = BundleFileLocatorHelperFactory.getFactory().getHelper().getFileURL(url);
                if (!url.getProtocol().equals("file") || (folder = (res = Resource.newResource((URL)url)).getFile()) == null) continue;
                files.add(folder);
            }
            catch (Throwable mfe) {
                LOG.warn(mfe);
            }
        }
        return files;
    }
}

