/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.ServiceProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceWatcher
implements ServiceListener {
    private static Logger LOG = Log.getLogger(ServiceWatcher.class);
    public static final String FILTER = "(objectclass=" + ServiceProvider.class.getName() + ")";
    ServiceTracker _serviceTracker;

    public ServiceWatcher() throws Exception {
        Bundle myBundle = FrameworkUtil.getBundle(this.getClass());
        this._serviceTracker = new ServiceTracker(myBundle.getBundleContext(), FrameworkUtil.createFilter((String)FILTER), null);
        this._serviceTracker.open();
    }

    public Map<ServiceReference, ServiceProvider> getDeployers(String managedServerName) {
        if (managedServerName == null) {
            managedServerName = "defaultJettyServer";
        }
        HashMap<ServiceReference, ServiceProvider> candidates = new HashMap<ServiceReference, ServiceProvider>();
        ServiceReference[] references = this._serviceTracker.getServiceReferences();
        if (references != null) {
            for (ServiceReference ref : references) {
                ServiceProvider candidate;
                String name = (String)ref.getProperty("managedServerName");
                if (!managedServerName.equalsIgnoreCase(name) || (candidate = (ServiceProvider)this._serviceTracker.getService(ref)) == null) continue;
                candidates.put(ref, candidate);
            }
        }
        return candidates;
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 2: 
            case 4: {
                BundleContext context = FrameworkUtil.getBundle(JettyBootstrapActivator.class).getBundleContext();
                ContextHandler contextHandler = (ContextHandler)context.getService(sr);
                String watermark = (String)sr.getProperty("o.e.j.o.b.watermark");
                String serverName = (String)sr.getProperty("managedServerName");
                Map<ServiceReference, ServiceProvider> candidates = this.getDeployers(serverName);
                if (candidates != null) {
                    boolean removed = false;
                    Iterator<Map.Entry<ServiceReference, ServiceProvider>> itor = candidates.entrySet().iterator();
                    while (!removed && itor.hasNext()) {
                        Map.Entry<ServiceReference, ServiceProvider> e = itor.next();
                        try {
                            removed = e.getValue().serviceRemoved(sr, contextHandler);
                        }
                        catch (Exception x) {
                            LOG.warn("Error undeploying service representing jetty context ", (Throwable)x);
                        }
                    }
                }
                if (ev.getType() == 4) break;
            }
            case 1: {
                Bundle contributor = sr.getBundle();
                BundleContext context = FrameworkUtil.getBundle(JettyBootstrapActivator.class).getBundleContext();
                ContextHandler contextHandler = (ContextHandler)context.getService(sr);
                if (contextHandler.getServer() != null) {
                    return;
                }
                String watermark = (String)sr.getProperty("o.e.j.o.b.watermark");
                if (watermark != null && !"".equals(watermark)) {
                    return;
                }
                String serverName = (String)sr.getProperty("managedServerName");
                Map<ServiceReference, ServiceProvider> candidates = this.getDeployers(serverName);
                if (candidates == null) break;
                boolean added = false;
                Iterator<Map.Entry<ServiceReference, ServiceProvider>> itor = candidates.entrySet().iterator();
                while (!added && itor.hasNext()) {
                    Map.Entry<ServiceReference, ServiceProvider> e = itor.next();
                    try {
                        added = e.getValue().serviceAdded(sr, contextHandler);
                        System.err.println(serverName + " deployed " + contextHandler + ": " + added);
                        if (!added || !LOG.isDebugEnabled()) continue;
                        LOG.debug("Provider " + e.getValue() + " deployed " + contextHandler, new Object[0]);
                    }
                    catch (Exception x) {
                        LOG.warn("Error deploying service representing jetty context", (Throwable)x);
                    }
                }
                break;
            }
        }
    }
}

