/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.annotations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.osgi.annotations.AnnotationParser;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;

public class AnnotationConfiguration
extends org.eclipse.jetty.annotations.AnnotationConfiguration {
    private static final Logger LOG = Log.getLogger(org.eclipse.jetty.annotations.AnnotationConfiguration.class);

    protected org.eclipse.jetty.annotations.AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    public void parseWebInfLib(WebAppContext context, org.eclipse.jetty.annotations.AnnotationParser parser) throws Exception {
        AnnotationParser oparser = (AnnotationParser)parser;
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        Bundle[] fragAndRequiredBundles = PackageAdminServiceTracker.INSTANCE.getFragmentsAndRequiredBundles(webbundle);
        if (fragAndRequiredBundles != null) {
            for (Bundle bundle : fragAndRequiredBundles) {
                Resource bundleRes = oparser.indexBundle(bundle);
                if (!context.getMetaData().getWebInfJars().contains(bundleRes)) {
                    context.getMetaData().addWebInfJar(bundleRes);
                }
                if (bundle.getHeaders().get("Fragment-Host") == null) continue;
                this.parseFragmentBundle(context, oparser, webbundle, bundle);
            }
        }
        oparser.indexBundle(webbundle);
        this.parseWebBundle(context, oparser, webbundle);
        super.parseWebInfLib(context, parser);
        if (fragAndRequiredBundles != null) {
            for (Bundle requiredBundle : fragAndRequiredBundles) {
                if (requiredBundle.getHeaders().get("Fragment-Host") != null) continue;
                this.parseRequiredBundle(context, oparser, webbundle, requiredBundle);
            }
        }
    }

    protected void parseFragmentBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle fragmentBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, fragmentBundle);
    }

    protected void parseWebBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle) throws Exception {
        this.parseBundle(context, parser, webbundle, webbundle);
    }

    protected void parseRequiredBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle requiredBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, requiredBundle);
    }

    protected void parseBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle bundle) throws Exception {
        Resource bundleRes = parser.getResource(bundle);
        HashSet<ClassInheritanceHandler> handlers = new HashSet<ClassInheritanceHandler>();
        handlers.addAll(this._discoverableAnnotationHandlers);
        if (this._classInheritanceHandler != null) {
            handlers.add(this._classInheritanceHandler);
        }
        handlers.addAll(this._containerInitializerAnnotationHandlers);
        ClassNameResolver classNameResolver = this.createClassNameResolver(context);
        if (this._parserTasks != null) {
            BundleParserTask task = new BundleParserTask(parser, handlers, bundleRes, classNameResolver);
            this._parserTasks.add(task);
            if (LOG.isDebugEnabled()) {
                task.setStatistic(new AnnotationConfiguration.TimeStatistic((org.eclipse.jetty.annotations.AnnotationConfiguration)this));
            }
        }
    }

    protected ClassNameResolver createClassNameResolver(WebAppContext context) {
        return this.createClassNameResolver(context, true, false, false, false);
    }

    protected ClassNameResolver createClassNameResolver(final WebAppContext context, final boolean excludeSysClass, final boolean excludeServerClass, final boolean excludeEverythingElse, final boolean overrideIsParenLoaderIsPriority) {
        return new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return excludeSysClass;
                }
                if (context.isServerClass(name)) {
                    return excludeServerClass;
                }
                return excludeEverythingElse;
            }

            public boolean shouldOverride(String name) {
                if (context.isParentLoaderPriority()) {
                    return overrideIsParenLoaderIsPriority;
                }
                return !overrideIsParenLoaderIsPriority;
            }
        };
    }

    public class BundleParserTask
    extends AnnotationConfiguration.ParserTask {
        public BundleParserTask(AnnotationParser parser, Set<? extends AnnotationParser.Handler> handlers, Resource resource, ClassNameResolver resolver) {
            super((org.eclipse.jetty.annotations.AnnotationConfiguration)AnnotationConfiguration.this, (org.eclipse.jetty.annotations.AnnotationParser)parser, handlers, resource, resolver);
        }

        public Void call() throws Exception {
            if (this._parser != null) {
                AnnotationParser osgiAnnotationParser = (AnnotationParser)this._parser;
                Bundle bundle = osgiAnnotationParser.getBundle(this._resource);
                if (this._stat != null) {
                    this._stat.start();
                }
                osgiAnnotationParser.parse((Set<? extends AnnotationParser.Handler>)this._handlers, bundle, this._resolver);
                if (this._stat != null) {
                    this._stat.end();
                }
            }
            return null;
        }
    }
}

