/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractOSGiApp
extends App {
    private static final Logger LOG = Log.getLogger(AbstractOSGiApp.class);
    protected Bundle _bundle;
    protected Dictionary _properties;
    protected ServiceRegistration _registration;

    public AbstractOSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle, String originId) {
        super(manager, provider, originId);
        this._properties = bundle.getHeaders();
        this._bundle = bundle;
    }

    public AbstractOSGiApp(DeploymentManager manager, AppProvider provider, Bundle bundle, Dictionary properties, String originId) {
        super(manager, provider, originId);
        this._properties = properties;
        this._bundle = bundle;
    }

    public String getBundleSymbolicName() {
        return this._bundle.getSymbolicName();
    }

    public String getBundleVersionAsString() {
        if (this._bundle.getVersion() == null) {
            return null;
        }
        return this._bundle.getVersion().toString();
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public void setRegistration(ServiceRegistration registration) {
        this._registration = registration;
    }

    public ServiceRegistration getRegistration() {
        return this._registration;
    }

    public void registerAsOSGiService() throws Exception {
        if (this._registration == null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("o.e.j.o.b.watermark", "o.e.j.o.b.watermark");
            if (this.getBundleSymbolicName() != null) {
                ((Dictionary)properties).put("osgi.web.symbolicname", this.getBundleSymbolicName());
            }
            if (this.getBundleVersionAsString() != null) {
                ((Dictionary)properties).put("osgi.web.version", this.getBundleVersionAsString());
            }
            ((Dictionary)properties).put("osgi.web.contextpath", this.getContextPath());
            ServiceRegistration rego = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext().registerService(ContextHandler.class.getName(), (Object)this.getContextHandler(), properties);
            this.setRegistration(rego);
        }
    }

    protected void deregisterAsOSGiService() throws Exception {
        if (this._registration == null) {
            return;
        }
        this._registration.unregister();
        this._registration = null;
    }

    protected Resource getFileAsResource(String dir, String file) {
        Resource r = null;
        try {
            File asFile = new File(dir, file);
            if (asFile.exists()) {
                r = Resource.newResource((File)asFile);
            }
        }
        catch (Exception e) {
            r = null;
        }
        return r;
    }

    protected Resource getFileAsResource(String file) {
        Resource r = null;
        try {
            File asFile = new File(file);
            if (asFile.exists()) {
                r = Resource.newResource((File)asFile);
            }
        }
        catch (Exception e) {
            r = null;
        }
        return r;
    }

    protected Resource findFile(String fileName, String jettyHome, String bundleOverrideLocation, Bundle containingBundle) {
        Resource res = null;
        if (fileName.startsWith("/")) {
            res = this.getFileAsResource(fileName);
        }
        if (res != null) {
            return res;
        }
        if (jettyHome != null) {
            if (jettyHome.startsWith("\"") || jettyHome.startsWith("'")) {
                jettyHome = jettyHome.substring(1);
            }
            if (jettyHome.endsWith("\"") || jettyHome.endsWith("'")) {
                jettyHome = jettyHome.substring(0, jettyHome.length() - 1);
            }
            res = this.getFileAsResource(jettyHome, fileName);
        }
        if (res != null) {
            return res;
        }
        if (bundleOverrideLocation != null) {
            try (Resource location = Resource.newResource((String)bundleOverrideLocation);){
                res = location.addPath(fileName);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (res != null) {
            return res;
        }
        if (containingBundle != null) {
            URL entry;
            if (fileName.startsWith("./")) {
                fileName = fileName.substring(1);
            }
            if (!fileName.startsWith("/")) {
                fileName = "/" + fileName;
            }
            if ((entry = this._bundle.getEntry(fileName)) != null) {
                res = Resource.newResource((URL)entry);
            }
        }
        return res;
    }
}

