/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQuicConfiguration
extends QuicConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ClientQuicConfiguration.class);
    private final SslContextFactory.Client sslContextFactory;

    public ClientQuicConfiguration(SslContextFactory.Client sslContextFactory, Path pemWorkDirectory) {
        this.sslContextFactory = sslContextFactory;
        this.setPemWorkDirectory(pemWorkDirectory);
        this.setSessionRecvWindow(0x1000000);
        this.setBidirectionalStreamRecvWindow(0x800000);
    }

    public SslContextFactory.Client getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void doStart() throws Exception {
        String certAlias;
        this.addBean(this.sslContextFactory);
        super.doStart();
        Path pemWorkDirectory = this.getPemWorkDirectory();
        KeyStore trustStore = this.sslContextFactory.getTrustStore();
        if (trustStore != null) {
            Path trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)pemWorkDirectory);
            this.getImplementationConfiguration().put(TRUSTED_CERTIFICATES_PEM_PATH_KEY, trustedCertificatesPemPath);
        }
        if ((certAlias = this.sslContextFactory.getCertAlias()) != null) {
            KeyStore keyStore = this.sslContextFactory.getKeyStore();
            String keyManagerPassword = this.sslContextFactory.getKeyManagerPassword();
            char[] password = keyManagerPassword == null ? this.sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
            Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)certAlias, (char[])password, (Path)pemWorkDirectory);
            Path privateKeyPemPath = keyPair[0];
            this.getImplementationConfiguration().put(PRIVATE_KEY_PEM_PATH_KEY, privateKeyPemPath);
            Path certificateChainPemPath = keyPair[1];
            this.getImplementationConfiguration().put(CERTIFICATE_CHAIN_PEM_PATH_KEY, certificateChainPemPath);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        Path certificateChainPemPath = (Path)this.getImplementationConfiguration().remove(CERTIFICATE_CHAIN_PEM_PATH_KEY);
        this.deleteFile(certificateChainPemPath);
        Path privateKeyPemPath = (Path)this.getImplementationConfiguration().remove(PRIVATE_KEY_PEM_PATH_KEY);
        this.deleteFile(privateKeyPemPath);
        Path trustedCertificatesPemPath = (Path)this.getImplementationConfiguration().remove(TRUSTED_CERTIFICATES_PEM_PATH_KEY);
        this.deleteFile(trustedCertificatesPemPath);
    }

    private void deleteFile(Path path) {
        block3: {
            try {
                if (path != null) {
                    Files.delete(path);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)path, (Object)x);
            }
        }
    }
}

