/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.common.StreamId;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStream
implements Stream,
CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStream.class);
    private final long streamId;
    private final boolean local;
    private Stream.Listener listener;
    private long idleTimeout;
    private long expireNanoTime = Long.MAX_VALUE;

    protected AbstractStream(long streamId, boolean local) {
        this.streamId = streamId;
        this.local = local;
    }

    public long getId() {
        return this.streamId;
    }

    public boolean isBidirectional() {
        return StreamId.isBidirectional(this.getId());
    }

    public boolean isLocal() {
        return this.local;
    }

    public Stream.Listener getListener() {
        return this.listener;
    }

    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting idle timeout {} ms for {}", (Object)idleTimeout, (Object)this);
        }
        this.idleTimeout = idleTimeout;
        this.notIdle();
    }

    protected void notIdle() {
        long idleTimeout = this.getIdleTimeout();
        this.expireNanoTime = idleTimeout > 0L ? NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(idleTimeout) : Long.MAX_VALUE;
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    public String toString() {
        return "%s@%x#%d".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getId());
    }
}

