/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.client;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.quiche.client.QuicheClientQuicConfiguration;
import org.eclipse.jetty.quic.quiche.client.internal.ClientQuicheConnection;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class QuicheClientConnectionFactory
extends ClientConnectionFactory.Wrapper {
    private final QuicheClientQuicConfiguration quicConfiguration;

    public QuicheClientConnectionFactory(ClientConnectionFactory connectionFactory, QuicheClientQuicConfiguration quicConfiguration) {
        super(connectionFactory);
        this.quicConfiguration = quicConfiguration;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ClientConnector clientConnector = (ClientConnector)context.get(ClientConnector.CONTEXT_KEY);
        SslContextFactory.Client sslContextFactory = (SslContextFactory.Client)context.get(ClientConnector.SSL_CONTEXT_FACTORY_CONTEXT_KEY);
        if (sslContextFactory == null) {
            sslContextFactory = clientConnector.getSslContextFactory();
        }
        ClientQuicheConnection connection = new ClientQuicheConnection(clientConnector, sslContextFactory, this.quicConfiguration, this.getWrapped(), endPoint, context);
        return this.customize((Connection)connection, context);
    }
}

