/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.client;

import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.quic.quiche.PemPaths;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheClientQuicConfiguration
extends ClientQuicConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheClientQuicConfiguration.class);
    private Path pemWorkDirectory;
    private boolean disableActiveMigration;

    public QuicheClientQuicConfiguration() {
        this(null);
    }

    public QuicheClientQuicConfiguration(Path pemWorkDirectory) {
        this.pemWorkDirectory = pemWorkDirectory;
    }

    public Path getPemWorkDirectory() {
        return this.pemWorkDirectory;
    }

    public void setPemWorkDirectory(Path pemWorkDirectory) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot change PEM working directory after start");
        }
        this.pemWorkDirectory = pemWorkDirectory;
    }

    public boolean isDisableActiveMigration() {
        return this.disableActiveMigration;
    }

    public void setDisableActiveMigration(boolean disableActiveMigration) {
        this.disableActiveMigration = disableActiveMigration;
    }

    public void configure(SslContextFactory.Client sslContextFactory) throws Exception {
        this.getImplementationConfiguration().computeIfAbsent(sslContextFactory, key -> {
            try {
                String certAlias;
                Path pemWorkDirectory = this.getPemWorkDirectory();
                Path privateKeyPemPath = null;
                Path certificateChainPemPath = null;
                Path trustedCertificatesPemPath = null;
                KeyStore trustStore = sslContextFactory.getTrustStore();
                if (trustStore != null) {
                    trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)pemWorkDirectory);
                }
                if ((certAlias = sslContextFactory.getCertAlias()) != null) {
                    KeyStore keyStore = sslContextFactory.getKeyStore();
                    String keyManagerPassword = sslContextFactory.getKeyManagerPassword();
                    char[] password = keyManagerPassword == null ? sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
                    Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)certAlias, (char[])password, (Path)pemWorkDirectory);
                    privateKeyPemPath = keyPair[0];
                    certificateChainPemPath = keyPair[1];
                }
                return new PemPaths(privateKeyPemPath, certificateChainPemPath, trustedCertificatesPemPath);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        });
    }

    public void deconfigure(SslContextFactory.Client sslContextFactory) {
        PemPaths pemPaths = (PemPaths)this.getImplementationConfiguration().remove(sslContextFactory);
        if (pemPaths != null) {
            this.deleteFile(pemPaths.privateKeyPemPath());
            this.deleteFile(pemPaths.certificateChainPemPath());
            this.deleteFile(pemPaths.trustedCertificatesPemPath());
        }
    }

    private void deleteFile(Path path) {
        block3: {
            try {
                if (path != null) {
                    Files.delete(path);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)path, (Object)x);
            }
        }
    }
}

