/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.client;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.Frame;
import org.eclipse.jetty.quic.client.ClientProtocolSession;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.ProtocolStreamListener;
import org.eclipse.jetty.quic.quiche.client.QuicheClientConnectionFactory;
import org.eclipse.jetty.quic.quiche.client.QuicheClientQuicConfiguration;
import org.eclipse.jetty.quic.quiche.client.internal.ClientQuicheSession;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheTransport
extends Transport.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheTransport.class);
    private final QuicheClientQuicConfiguration quicConfiguration;

    public QuicheTransport(QuicheClientQuicConfiguration quicConfiguration) {
        this(UDP_IP, quicConfiguration);
    }

    public QuicheTransport(Transport wrapped, QuicheClientQuicConfiguration quicConfiguration) {
        super(wrapped);
        this.quicConfiguration = quicConfiguration;
    }

    public boolean isIntrinsicallySecure() {
        return true;
    }

    public ClientConnectionFactory newClientConnectionFactory(ClientConnector connector, ClientConnectionFactory factory) {
        factory = super.newClientConnectionFactory(connector, factory);
        return new QuicheClientConnectionFactory(factory, this.quicConfiguration);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        context.put(Session.Listener.class.getName(), new ProtocolSessionListener(context));
        return super.newConnection(endPoint, context);
    }

    public int hashCode() {
        return this.getWrapped().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuicheTransport) {
            QuicheTransport that = (QuicheTransport)((Object)obj);
            return Objects.equals(this.getWrapped(), that.getWrapped());
        }
        return false;
    }

    private static class ProtocolSessionListener
    implements AbstractSession.Listener {
        private final AtomicReference<ProtocolSession> protocolSession = new AtomicReference();
        private final Map<String, Object> context;

        private ProtocolSessionListener(Map<String, Object> context) {
            this.context = context;
        }

        public void onOpen(Session session) {
            try {
                ClientQuicheSession qSession = (ClientQuicheSession)session;
                ProtocolSession pSession = this.newProtocolSession(qSession);
                qSession.addManaged((LifeCycle)pSession);
                this.protocolSession.set(pSession);
                this.context.put(ClientConnector.APPLICATION_PROTOCOL_CONTEXT_KEY, qSession.getNegotiatedProtocol());
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not create ProtocolSession", x);
                }
                session.disconnect(new ConnectionCloseFrame(ErrorCode.APPLICATION_ERROR.code(), "invalid_protocol"), x, Promise.Invocable.noop());
            }
        }

        public Stream.Listener onNewStream(Session session, Frame.WithStreamId frame) {
            return new ProtocolStreamListener.Server(this.protocolSession.get());
        }

        public boolean onIdleTimeout(Session session, TimeoutException failure) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                return pSession.onIdleTimeout(failure);
            }
            return true;
        }

        public CompletableFuture<Session> onLocalShutdown(Session session) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                return pSession.shutdown().thenApply(ps -> session);
            }
            return CompletableFuture.completedFuture(session);
        }

        public void onLocalClose(Session session, ConnectionCloseFrame frame, Promise.Invocable<Session> promise) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                pSession.close(frame, Promise.Invocable.toPromise(promise, ps -> session));
            } else {
                promise.succeeded((Object)session);
            }
        }

        public void onClose(Session session, ConnectionCloseFrame frame) {
            ProtocolSession pSession = this.protocolSession.get();
            if (pSession != null) {
                pSession.onClose(frame);
            }
        }

        private ProtocolSession newProtocolSession(ClientQuicheSession session) {
            ClientConnectionFactory connectionFactory = session.getClientConnectionFactory();
            ProtocolSession protocolSession = null;
            if (connectionFactory instanceof ProtocolSession.Factory) {
                ProtocolSession.Factory psf = (ProtocolSession.Factory)connectionFactory;
                protocolSession = psf.newProtocolSession((Session)session, this.context);
            }
            if (protocolSession != null) {
                return protocolSession;
            }
            if (connectionFactory instanceof Container) {
                Container container = (Container)connectionFactory;
                for (ProtocolSession.Factory psf : container.getBeans(ProtocolSession.Factory.class)) {
                    protocolSession = psf.newProtocolSession((Session)session, this.context);
                    if (protocolSession == null) continue;
                    return protocolSession;
                }
            }
            ClientConnector connector = (ClientConnector)this.context.get(ClientConnector.CONTEXT_KEY);
            return new ClientProtocolSession(connector, (Session)session, connectionFactory, this.context);
        }
    }
}

