/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.client.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.quiche.PemPaths;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.QuicheConnectionId;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.quic.quiche.client.QuicheClientQuicConfiguration;
import org.eclipse.jetty.quic.quiche.client.internal.ClientQuicheSession;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQuicheConnection
extends QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ClientQuicheConnection.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ClientConnector connector;
    private final SslContextFactory.Client sslContextFactory;
    private final QuicheClientQuicConfiguration quicConfiguration;
    private final ClientConnectionFactory connectionFactory;
    private final Map<String, Object> context;
    private Scheduler.Task connectTask;
    private ClientQuicheSession session;

    public ClientQuicheConnection(ClientConnector connector, SslContextFactory.Client sslContextFactory, QuicheClientQuicConfiguration quicConfiguration, ClientConnectionFactory connectionFactory, EndPoint endPoint, Map<String, Object> context) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        this.connector = connector;
        this.sslContextFactory = sslContextFactory;
        this.quicConfiguration = quicConfiguration;
        this.connectionFactory = connectionFactory;
        this.context = context;
        quicConfiguration.getEventListeners().forEach(arg_0 -> ((ClientQuicheConnection)this).addEventListener(arg_0));
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public void onOpen() {
        try {
            Path trustedCertificatesPemPath;
            Path certificateChainPemPath;
            super.onOpen();
            List protocols = (List)this.context.get(ClientConnector.APPLICATION_PROTOCOLS_CONTEXT_KEY);
            if (protocols == null || protocols.isEmpty()) {
                throw new IllegalStateException("missing ALPN protocols");
            }
            this.quicConfiguration.configure(this.sslContextFactory);
            QuicheConfig quicheConfig = new QuicheConfig();
            quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
            quicheConfig.setDisableActiveMigration(Boolean.valueOf(this.quicConfiguration.isDisableActiveMigration()));
            quicheConfig.setVerifyPeer(Boolean.valueOf(!this.sslContextFactory.isTrustAll()));
            PemPaths pemPaths = (PemPaths)this.quicConfiguration.getImplementationConfiguration().get(this.sslContextFactory);
            Path privateKeyPemPath = pemPaths.privateKeyPemPath();
            if (privateKeyPemPath != null) {
                quicheConfig.setPrivKeyPemPath(privateKeyPemPath.toString());
            }
            if ((certificateChainPemPath = pemPaths.certificateChainPemPath()) != null) {
                quicheConfig.setCertChainPemPath(certificateChainPemPath.toString());
            }
            if ((trustedCertificatesPemPath = pemPaths.trustedCertificatesPemPath()) != null) {
                quicheConfig.setTrustedCertsPemPath(trustedCertificatesPemPath.toString());
            }
            quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
            quicheConfig.setInitialMaxData(Long.valueOf(this.quicConfiguration.getSessionMaxData()));
            quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(this.quicConfiguration.getLocalBidirectionalStreamMaxData()));
            quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(this.quicConfiguration.getRemoteBidirectionalStreamMaxData()));
            quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(this.quicConfiguration.getUnidirectionalStreamMaxData()));
            quicheConfig.setInitialMaxStreamsUni(Long.valueOf(this.quicConfiguration.getUnidirectionalMaxStreams()));
            quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(this.quicConfiguration.getBidirectionalMaxStreams()));
            quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
            SocketAddress localAddress = this.getEndPoint().getLocalSocketAddress();
            InetSocketAddress inetLocalAddress = Quiche.toInetSocketAddress((SocketAddress)localAddress, (boolean)true);
            SocketAddress remoteAddress = (SocketAddress)this.context.get(ClientConnector.REMOTE_SOCKET_ADDRESS_CONTEXT_KEY);
            InetSocketAddress inetRemoteAddress = Quiche.toInetSocketAddress((SocketAddress)remoteAddress, (boolean)false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("connecting to {} with protocols {}", (Object)remoteAddress, (Object)protocols);
            }
            Quiche quiche = Quiche.connect((QuicheConfig)quicheConfig, (InetSocketAddress)inetLocalAddress, (InetSocketAddress)inetRemoteAddress);
            Session.Listener listener = (Session.Listener)this.context.get(Session.Listener.class.getName());
            this.session = new ClientQuicheSession(this.connector, this.quicConfiguration, quiche, this, inetLocalAddress, inetRemoteAddress, listener);
            this.session.setIdleTimeout(this.getEndPoint().getIdleTimeout());
            this.session.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug("created {}", (Object)this.session);
            }
            this.connectTask = this.getScheduler().schedule(() -> this.connectTimeout(remoteAddress), this.connector.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS);
            this.session.flush();
            this.fillInterested();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not open {}", (Object)this);
            }
            this.fail(ErrorCode.INTERNAL_ERROR.code(), "open_failure", x);
        }
    }

    public void onClose(Throwable cause) {
        super.onClose(cause);
        this.quicConfiguration.deconfigure(this.sslContextFactory);
    }

    public void onFillable() {
        this.connectTask.cancel();
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(this.getInputBufferSize(), this.quicConfiguration.isUseInputDirectByteBuffers());
        ByteBuffer cipherBuffer = buffer.getByteBuffer();
        try {
            while (true) {
                QuicheConnectionId connectionId;
                int filled;
                BufferUtil.clear((ByteBuffer)cipherBuffer);
                SocketAddress remoteAddress = this.getEndPoint().receive(cipherBuffer);
                int n = filled = remoteAddress == EndPoint.EOF ? -1 : cipherBuffer.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("filled cipher buffer with {} byte(s)", (Object)filled);
                }
                if (filled < 0) {
                    buffer.release();
                    this.getEndPoint().shutdownOutput();
                    return;
                }
                if (filled == 0) {
                    buffer.release();
                    this.fillInterested();
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("peer ip address: {}, ciphertext packet size: {}", (Object)remoteAddress, (Object)cipherBuffer.remaining());
                }
                if ((connectionId = QuicheConnectionId.fromPacket((ByteBuffer)cipherBuffer)) == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("dropping packet contains undecipherable connection id");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("packet contains connection id {}", (Object)connectionId);
                }
                this.session.setConnectionId(connectionId);
                InetSocketAddress inetRemoteAddress = Quiche.toInetSocketAddress((SocketAddress)remoteAddress, (boolean)false);
                this.session.feed(inetRemoteAddress, cipherBuffer);
                if (this.session.isConnectionEstablished()) {
                    if (!this.session.isOpen()) {
                        this.session.open();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("opened {}", (Object)this.session);
                        }
                    }
                    this.session.produce();
                    continue;
                }
                this.session.flush();
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("receive failure on {}", (Object)this, (Object)x);
            }
            buffer.release();
            this.fail(ErrorCode.INTERNAL_ERROR.code(), "receive_failure", x);
            return;
        }
    }

    private void connectTimeout(SocketAddress remoteAddress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect timeout {} ms to {} on {}", new Object[]{this.connector.getConnectTimeout(), remoteAddress, this});
        }
        this.fail(ErrorCode.CONNECTION_REFUSED_ERROR.code(), "connect_timeout", new SocketTimeoutException("connect timeout"));
    }

    public void write(Callback callback, SocketAddress remoteAddress, ByteBuffer ... buffers) {
        this.getEndPoint().write(callback, remoteAddress, buffers);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        boolean idle = this.isFillInterested();
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} elapsed idle timeout {} ms", (Object)(idle ? "processing" : "ignoring"), (Object)idleTimeout);
        }
        if (idle) {
            return this.session.onIdleTimeout(timeoutException);
        }
        return false;
    }

    public void close() {
        try (Blocker.Promise promise = Blocker.promise();){
            this.close(new ConnectionCloseFrame(ErrorCode.NO_ERROR.code(), "close"), (Promise.Invocable<Session>)promise);
            promise.block();
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    private void close(ConnectionCloseFrame frame, Promise.Invocable<Session> promise) {
        if (!this.closed.compareAndSet(false, true)) {
            promise.succeeded((Object)this.session);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing {}", (Object)this);
        }
        this.session.close(frame, promise);
    }

    public void disconnect(QuicheSession session, ConnectionCloseFrame frame, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting {}", (Object)this);
        }
        this.session = null;
        this.getEndPoint().close(failure);
    }

    private void fail(long error, String reason, Throwable failure) {
        this.disconnect(this.session, new ConnectionCloseFrame(error, reason), failure);
        Promise promise = (Promise)this.context.get(ClientConnector.CONNECTION_PROMISE_CONTEXT_KEY);
        if (promise != null) {
            promise.failed(failure);
        }
    }
}

