/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.client.internal;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.StreamId;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.QuicheSession;
import org.eclipse.jetty.quic.quiche.client.QuicheClientQuicConfiguration;
import org.eclipse.jetty.quic.quiche.client.internal.ClientQuicheConnection;

public class ClientQuicheSession
extends QuicheSession {
    private final AtomicLong biStreamIds = new AtomicLong();
    private final AtomicLong uniStreamIds = new AtomicLong();

    public ClientQuicheSession(ClientConnector connector, QuicheClientQuicConfiguration configuration, Quiche quiche, ClientQuicheConnection connection, SocketAddress localAddress, SocketAddress remoteAddress, Session.Listener listener) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), (QuicConfiguration)configuration, quiche, (QuicheConnection)connection, localAddress, remoteAddress, listener);
    }

    public long newStreamId(boolean bidirectional) {
        AtomicLong streamIds = bidirectional ? this.biStreamIds : this.uniStreamIds;
        return StreamId.newStreamId((long)streamIds.getAndIncrement(), (boolean)bidirectional, (boolean)true);
    }

    protected ClientQuicheConnection getConnection() {
        return (ClientQuicheConnection)super.getConnection();
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.getConnection().getClientConnectionFactory();
    }
}

