/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheConnectionId {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheConnectionId.class);
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
    private final byte[] dcid;
    private final int hashCode;
    private String string;

    private QuicheConnectionId(byte[] dcid) {
        this.dcid = Objects.requireNonNull(dcid);
        this.hashCode = Arrays.hashCode(dcid);
    }

    public static QuicheConnectionId fromPacket(ByteBuffer packet) {
        QuicheConnectionId connectionId;
        byte[] bytes = QuicheConnection.QUICHE_BINDING.fromPacket(packet);
        if (bytes != null && bytes.length == 0) {
            throw new IllegalStateException();
        }
        QuicheConnectionId quicheConnectionId = connectionId = bytes == null ? null : new QuicheConnectionId(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("snooped connection ID from packet: [{}]", (Object)connectionId);
        }
        return connectionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuicheConnectionId that = (QuicheConnectionId)o;
        return Arrays.equals(this.dcid, that.dcid);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            this.string = QuicheConnectionId.bytesToHex(this.dcid);
        }
        return this.string;
    }

    private static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[c >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[c & 0xF];
        }
        return new String(hexChars, StandardCharsets.US_ASCII);
    }
}

