/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.MaxDataFrame;
import org.eclipse.jetty.quic.api.frames.MaxStreamsFrame;
import org.eclipse.jetty.quic.common.AbstractSession;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.QuicheConnectionId;
import org.eclipse.jetty.quic.quiche.QuicheStream;
import org.eclipse.jetty.quic.util.ErrorCode;
import org.eclipse.jetty.quic.util.QuicException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuicheSession
extends AbstractSession {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheSession.class);
    private final Map<Long, QuicheStream> streams = new ConcurrentHashMap<Long, QuicheStream>();
    private final Scheduler scheduler;
    private final ByteBufferPool byteBufferPool;
    private final Quiche quiche;
    private final QuicheConnection connection;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final StreamTimeouts streamTimeouts;
    private final Flusher flusher;
    private final StreamsProducer producer;
    private final AdaptiveExecutionStrategy strategy;
    private QuicheConnectionId connectionId;
    private long idleTimeout;
    private boolean opened;

    public QuicheSession(Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, QuicConfiguration configuration, Quiche quiche, QuicheConnection connection, SocketAddress localAddress, SocketAddress remoteAddress, Session.Listener listener) {
        super(executor, configuration, listener);
        this.scheduler = scheduler;
        this.byteBufferPool = bufferPool;
        this.quiche = quiche;
        this.connection = connection;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.streamTimeouts = new StreamTimeouts(scheduler);
        this.flusher = new Flusher(scheduler);
        this.producer = new StreamsProducer();
        this.strategy = new AdaptiveExecutionStrategy((ExecutionStrategy.Producer)this.producer, executor);
        this.installBean(this.strategy);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    protected QuicheConnection getConnection() {
        return this.connection;
    }

    public String getNegotiatedProtocol() {
        return this.quiche.getNegotiatedProtocol();
    }

    public String getId() {
        return this.getConnectionId().toString();
    }

    public Stream newStream(long streamId, Stream.Listener listener) {
        QuicheStream stream = this.createLocalStream(streamId);
        stream.setListener(listener);
        return stream;
    }

    private QuicheStream createLocalStream(long streamId) {
        QuicheStream stream = new QuicheStream(this, streamId, true);
        if (this.streams.putIfAbsent(streamId, stream) == null) {
            stream.setIdleTimeout(this.getQuicConfiguration().getStreamIdleTimeout());
            if (LOG.isDebugEnabled()) {
                LOG.debug("created local {} on {}", (Object)stream, (Object)this);
            }
            return stream;
        }
        throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "duplicate_local_stream");
    }

    private QuicheStream createRemoteStream(long streamId) {
        QuicheStream stream = new QuicheStream(this, streamId, false);
        if (this.streams.putIfAbsent(streamId, stream) != null) {
            throw new QuicException(ErrorCode.FRAME_ENCODING_ERROR, "duplicate_remote_stream");
        }
        stream.setIdleTimeout(this.getQuicConfiguration().getStreamIdleTimeout());
        Stream.Listener listener = this.notifyNewStream();
        stream.setListener(listener);
        stream.onNewStream();
        if (LOG.isDebugEnabled()) {
            LOG.debug("created remote {} on {}", (Object)stream, (Object)this);
        }
        return stream;
    }

    public QuicheStream getStream(long streamId) {
        return this.streams.get(streamId);
    }

    public Collection<Stream> getStreams() {
        return List.copyOf(this.streams.values());
    }

    boolean remove(QuicheStream stream) {
        boolean removed;
        boolean bl = removed = this.streams.remove(stream.getId()) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {} {} from {}", new Object[]{removed, stream, this});
        }
        return removed;
    }

    public void maxStreams(MaxStreamsFrame frame, Promise.Invocable<Session> promise) {
        throw new UnsupportedOperationException();
    }

    public void ping(Promise.Invocable<Session> promise) {
        throw new UnsupportedOperationException();
    }

    public void maxData(MaxDataFrame frame, Promise.Invocable<Session> promise) {
        throw new UnsupportedOperationException();
    }

    public void disconnect(ConnectionCloseFrame frame, Throwable failure, Promise.Invocable<Session> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting {} {}", new Object[]{frame, this, failure});
        }
        for (QuicheStream stream : this.streams.values()) {
            stream.disconnect(false, frame.getErrorCode(), failure, (Promise.Invocable<Stream>)Promise.Invocable.noop());
        }
        this.quiche.close(frame.getErrorCode(), frame.getReason());
        this.flush();
        Promise.completeWith(promise, (CompletableFuture)this.flusher.disconnect().whenComplete((r, x) -> {
            LifeCycle.stop((Object)((Object)this));
            this.emitDisconnect();
            this.getConnection().disconnect(this, frame, failure);
        }));
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localAddress;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteAddress;
    }

    public long getLocalBidirectionalMaxStreams() {
        return Integer.MAX_VALUE;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting idle timeout {} ms for {}", (Object)idleTimeout, (Object)this);
        }
        this.idleTimeout = idleTimeout;
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout {} ms expired for {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        return this.notifyIdleTimeout(timeout);
    }

    void scheduleIdleTimeout(QuicheStream stream) {
        this.streamTimeouts.schedule((CyclicTimeouts.Expirable)stream);
    }

    public QuicheConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(QuicheConnectionId connectionId) {
        this.connectionId = connectionId;
    }

    public void feed(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        int accepted;
        int remaining = cipherBuffer.remaining();
        if (LOG.isDebugEnabled()) {
            LOG.debug("feeding {} cipher bytes to {}", (Object)remaining, (Object)this);
        }
        if ((accepted = this.quiche.feedCipherBytes(cipherBuffer, this.localAddress, remoteAddress)) != remaining) {
            throw new IllegalStateException();
        }
    }

    public boolean isConnectionEstablished() {
        return this.quiche.isConnectionEstablished();
    }

    public X509Certificate[] getPeerCertificates() {
        try {
            byte[] encoded = this.quiche.getPeerCertificate();
            if (encoded == null) {
                return null;
            }
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encoded));
            return new X509Certificate[]{certificate};
        }
        catch (CertificateException x) {
            return null;
        }
    }

    public void produce() {
        this.strategy.produce();
    }

    Throwable isReset(QuicheStream stream) {
        try {
            this.quiche.drainClearBytesForStream(stream.getId(), BufferUtil.EMPTY_BUFFER, new boolean[1]);
            return null;
        }
        catch (EOFException x) {
            return x;
        }
        catch (Throwable x) {
            return null;
        }
    }

    int read(QuicheStream stream, ByteBuffer byteBuffer, boolean[] outLast) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading from {} on {}", (Object)stream, (Object)this);
        }
        int filled = this.quiche.drainClearBytesForStream(stream.getId(), byteBuffer, outLast);
        if (LOG.isDebugEnabled()) {
            LOG.debug("read {} bytes last={} from {} on {}", new Object[]{filled, outLast[0], stream, this});
        }
        this.flush();
        return filled;
    }

    protected int data(QuicheStream stream, boolean last, ByteBuffer buffer) throws IOException {
        return this.quiche.feedClearBytesForStream(stream.getId(), buffer, last);
    }

    public void offerTask(Runnable task) {
        this.producer.offer(task);
        this.strategy.produce();
    }

    boolean isFinished(QuicheStream stream) {
        try {
            return this.quiche.isStreamFinished(stream.getId());
        }
        catch (Throwable x) {
            return true;
        }
    }

    boolean isFailed(QuicheStream stream) {
        try {
            return this.quiche.windowCapacity(stream.getId()) < 0L;
        }
        catch (Throwable x) {
            return true;
        }
    }

    void shutdownStream(QuicheStream stream, boolean writeSide, long appErrorCode, Promise.Invocable<Stream> promise) {
        try {
            this.quiche.shutdownStream(stream.getId(), writeSide, appErrorCode);
            this.flush();
            promise.succeeded((Object)stream);
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    public void flush() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {}", (Object)this);
        }
        this.flusher.iterate();
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void open() {
        if (this.opened) {
            return;
        }
        this.opened = true;
        this.emitOpen();
    }

    private class StreamTimeouts
    extends CyclicTimeouts<QuicheStream> {
        private StreamTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<QuicheStream> iterator() {
            return QuicheSession.this.streams.values().iterator();
        }

        protected boolean onExpired(QuicheStream stream) {
            stream.onIdleTimeout(new TimeoutException("Idle timeout " + stream.getIdleTimeout() + " ms elapsed"));
            return false;
        }
    }

    private class Flusher
    extends IteratingCallback {
        private final CompletableFuture<Session> disconnect = new CompletableFuture();
        private final CyclicTimeout timeout;
        private RetainableByteBuffer cipherBuffer;

        public Flusher(Scheduler scheduler) {
            this.timeout = new CyclicTimeout(this, scheduler){
                final /* synthetic */ Flusher this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                public void onTimeoutExpired() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("quiche timeout expired {}", (Object)this.this$1.QuicheSession.this);
                    }
                    this.this$1.QuicheSession.this.quiche.onTimeout();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("re-iterating after quiche timeout {}", (Object)this.this$1.QuicheSession.this);
                    }
                    this.this$1.QuicheSession.this.getExecutor().execute(() -> this.this$1.iterate());
                }
            };
        }

        protected IteratingCallback.Action process() throws IOException {
            this.cipherBuffer = QuicheSession.this.getByteBufferPool().acquire(QuicheSession.this.getQuicConfiguration().getOutputBufferSize(), QuicheSession.this.getQuicConfiguration().isUseOutputDirectByteBuffers());
            ByteBuffer cipherByteBuffer = this.cipherBuffer.getByteBuffer();
            int pos = BufferUtil.flipToFill((ByteBuffer)cipherByteBuffer);
            int drained = QuicheSession.this.quiche.drainCipherBytes(cipherByteBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("drained {} byte(s) of cipher bytes from {}", (Object)drained, (Object)QuicheSession.this);
            }
            long nextTimeoutInMs = QuicheSession.this.quiche.nextTimeout();
            if (LOG.isDebugEnabled()) {
                LOG.debug("next quiche timeout: {} ms on {}", (Object)nextTimeoutInMs, (Object)QuicheSession.this);
            }
            if (nextTimeoutInMs < 0L) {
                this.timeout.cancel();
            } else {
                this.timeout.schedule(nextTimeoutInMs, TimeUnit.MILLISECONDS);
            }
            if (drained == 0) {
                IteratingCallback.Action action;
                boolean connectionClosed = QuicheSession.this.quiche.isConnectionClosed();
                IteratingCallback.Action action2 = action = connectionClosed ? IteratingCallback.Action.SUCCEEDED : IteratingCallback.Action.IDLE;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection draining={} closed={}, action={} on {}", new Object[]{QuicheSession.this.quiche.isDraining(), connectionClosed, action, QuicheSession.this});
                }
                if (action == IteratingCallback.Action.IDLE) {
                    this.cipherBuffer.release();
                }
                return action;
            }
            BufferUtil.flipToFlush((ByteBuffer)cipherByteBuffer, (int)pos);
            if (LOG.isDebugEnabled()) {
                LOG.debug("writing cipher bytes for {} on {}", (Object)QuicheSession.this.remoteAddress, (Object)QuicheSession.this);
            }
            QuicheSession.this.getConnection().write((Callback)this, QuicheSession.this.remoteAddress, cipherByteBuffer);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onSuccess() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("written cipher bytes on {}", (Object)QuicheSession.this);
            }
            this.cipherBuffer.release();
        }

        protected void onCompleteSuccess() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("connection closed {}", (Object)QuicheSession.this);
            }
            this.complete(null);
        }

        protected void onCompleteFailure(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("failed to write cipher bytes, closing session on {}", (Object)QuicheSession.this, (Object)failure);
            }
            this.complete(failure);
        }

        private void complete(Throwable failure) {
            this.cipherBuffer.release();
            this.timeout.destroy();
            QuicheSession.this.quiche.dispose();
            if (failure == null) {
                this.disconnect.complete((Session)QuicheSession.this);
            } else {
                this.disconnect.completeExceptionally(failure);
            }
        }

        private CompletableFuture<Session> disconnect() {
            return this.disconnect;
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private class StreamsProducer
    implements ExecutionStrategy.Producer {
        private final AutoLock lock = new AutoLock();
        private final Deque<Runnable> tasks = new ArrayDeque<Runnable>();

        private StreamsProducer() {
        }

        private void offer(Runnable task) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("queuing stream task {} on {}", (Object)task, (Object)QuicheSession.this);
            }
            try (AutoLock ignored = this.lock.lock();){
                this.tasks.offer(task);
            }
        }

        private Runnable poll() {
            try (AutoLock ignored = this.lock.lock();){
                Runnable runnable = this.tasks.poll();
                return runnable;
            }
        }

        public Runnable produce() {
            Runnable task = this.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("dequeued existing stream task {} on {}", (Object)task, (Object)QuicheSession.this);
            }
            if (task != null) {
                return task;
            }
            List<Long> writable = QuicheSession.this.quiche.writableStreamIds();
            if (LOG.isDebugEnabled()) {
                LOG.debug("writable stream ids: {} on {}", writable, (Object)QuicheSession.this);
            }
            for (Object stream : QuicheSession.this.streams.values()) {
                if (writable.contains(stream.getId())) {
                    stream.resumeWrite();
                    continue;
                }
                stream.tryFailWrite();
            }
            List<Long> readable = QuicheSession.this.quiche.readableStreamIds();
            if (LOG.isDebugEnabled()) {
                LOG.debug("readable stream ids: {} on {}", readable, (Object)QuicheSession.this);
            }
            for (Long streamId : readable) {
                QuicheStream stream = QuicheSession.this.streams.get(streamId);
                if (stream == null) {
                    stream = QuicheSession.this.createRemoteStream(streamId);
                }
                stream.readable();
            }
            task = this.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("dequeued produced stream task {} on {}", (Object)task, (Object)QuicheSession.this);
            }
            if (task != null) {
                return task;
            }
            Quiche.CloseInfo closeInfo = QuicheSession.this.quiche.getRemoteCloseInfo();
            if (closeInfo != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("remote close {} on {}", (Object)closeInfo, (Object)QuicheSession.this);
                }
                QuicheSession.this.notifyClose(new ConnectionCloseFrame(closeInfo.error(), closeInfo.reason()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("stream task production idle on {}", (Object)QuicheSession.this);
            }
            return null;
        }

        public String toString() {
            return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
        }
    }
}

