/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClusteredInvalidationSessionTest
extends AbstractTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidation() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int maxInactiveInterval = 30;
        int scavengeInterval = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(0);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengeInterval);
        TestServer server1 = new TestServer(0, maxInactiveInterval, scavengeInterval, (SessionCacheFactory)cacheFactory, storeFactory);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        try {
            server1.start();
            int port1 = server1.getPort();
            TestServer server2 = new TestServer(0, maxInactiveInterval, scavengeInterval, (SessionCacheFactory)cacheFactory, storeFactory);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            try {
                server2.start();
                int port2 = server2.getPort();
                HttpClient client = new HttpClient();
                QueuedThreadPool executor = new QueuedThreadPool();
                client.setExecutor((Executor)executor);
                client.start();
                try {
                    String[] urls = new String[]{"http://localhost:" + port1 + contextPath + servletMapping, "http://localhost:" + port2 + contextPath + servletMapping};
                    ContentResponse response1 = client.GET(urls[0] + "?action=init");
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    String sessionCookie = response1.getHeaders().get("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    Request request2 = client.newRequest(urls[1] + "?action=increment");
                    request2.header("Cookie", sessionCookie);
                    ContentResponse response2 = request2.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                    Request request1 = client.newRequest(urls[0] + "?action=invalidate");
                    request1.header("Cookie", sessionCookie);
                    response1 = request1.send();
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    request2 = client.newRequest(urls[1] + "?action=test");
                    request2.header("Cookie", sessionCookie);
                    response2 = request2.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("value", (Object)0);
            } else if ("increment".equals(action)) {
                HttpSession session = request.getSession(false);
                int value = (Integer)session.getAttribute("value");
                session.setAttribute("value", (Object)(value + 1));
            } else if ("invalidate".equals(action)) {
                HttpSession session = request.getSession(false);
                session.invalidate();
                try {
                    session.invalidate();
                    Assert.fail((String)"Session should be invalid");
                }
                catch (IllegalStateException illegalStateException) {}
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertEquals(null, (Object)session);
            }
        }
    }
}

