/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClusteredLastAccessTimeTest
extends AbstractTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastAccessTime() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int maxInactivePeriod = 8;
        int scavengePeriod = 2;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, maxInactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        TestServlet servlet1 = new TestServlet();
        ServletHolder holder1 = new ServletHolder((Servlet)servlet1);
        ServletContextHandler context = server1.addContext(contextPath);
        TestSessionListener listener1 = new TestSessionListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)listener1));
        context.addServlet(holder1, servletMapping);
        SessionHandler m1 = context.getSessionHandler();
        try {
            server1.start();
            int port1 = server1.getPort();
            TestServer server2 = new TestServer(0, maxInactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
            ServletContextHandler context2 = server2.addContext(contextPath);
            context2.addServlet(TestServlet.class, servletMapping);
            SessionHandler m2 = context2.getSessionHandler();
            try {
                server2.start();
                int port2 = server2.getPort();
                HttpClient client = new HttpClient();
                client.start();
                try {
                    ContentResponse response1 = client.GET("http://localhost:" + port1 + contextPath + servletMapping + "?action=init");
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    Assert.assertEquals((Object)"test", (Object)response1.getContentAsString());
                    String sessionCookie = response1.getHeaders().get("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    Assert.assertEquals((long)1L, (long)((DefaultSessionCache)m1.getSessionCache()).getSessionsCurrent());
                    Assert.assertEquals((long)1L, (long)((DefaultSessionCache)m1.getSessionCache()).getSessionsMax());
                    Assert.assertEquals((long)1L, (long)((DefaultSessionCache)m1.getSessionCache()).getSessionsTotal());
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    int requestInterval = 500;
                    for (int i = 0; i < maxInactivePeriod * (1000 / requestInterval); ++i) {
                        Request request = client.newRequest("http://localhost:" + port2 + contextPath + servletMapping);
                        request.header("Cookie", sessionCookie);
                        ContentResponse response2 = request.send();
                        Assert.assertEquals((long)200L, (long)response2.getStatus());
                        Assert.assertEquals((Object)"test", (Object)response2.getContentAsString());
                        String setCookie = response2.getHeaders().get("Set-Cookie");
                        if (setCookie != null) {
                            sessionCookie = setCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                        }
                        Thread.sleep(requestInterval);
                        this.assertSessionCounts(1, 1, 1, m2);
                    }
                    Thread.sleep((long)maxInactivePeriod + (long)scavengePeriod * 2500L);
                    Assert.assertFalse((boolean)listener1._destroys.contains(TestServer.extractSessionId(sessionCookie)));
                    this.assertAfterScavenge(m1);
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public void assertAfterSessionCreated(SessionHandler m) {
        this.assertSessionCounts(1, 1, 1, m);
    }

    public void assertAfterScavenge(SessionHandler manager) {
        this.assertSessionCounts(1, 1, 1, manager);
    }

    public void assertSessionCounts(int current, int max, int total, SessionHandler manager) {
        Assert.assertEquals((long)current, (long)((DefaultSessionCache)manager.getSessionCache()).getSessionsCurrent());
        Assert.assertEquals((long)max, (long)((DefaultSessionCache)manager.getSessionCache()).getSessionsMax());
        Assert.assertEquals((long)total, (long)((DefaultSessionCache)manager.getSessionCache()).getSessionsTotal());
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
                this.sendResult(session, httpServletResponse.getWriter());
            } else {
                HttpSession session = request.getSession(false);
                this.sendResult(session, httpServletResponse.getWriter());
                if (session != null) {
                    session.setAttribute("test", (Object)"test");
                }
            }
        }

        private void sendResult(HttpSession session, PrintWriter writer) {
            if (session != null) {
                writer.print(session.getAttribute("test"));
            } else {
                writer.print("null");
            }
        }
    }

    public static class TestSessionListener
    implements HttpSessionListener {
        public Set<String> _creates = new HashSet<String>();
        public Set<String> _destroys = new HashSet<String>();

        public void sessionDestroyed(HttpSessionEvent se) {
            this._destroys.add(se.getSession().getId());
        }

        public void sessionCreated(HttpSessionEvent se) {
            this._creates.add(se.getSession().getId());
        }
    }
}

