/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClusteredOrphanedSessionTest
extends AbstractTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrphanedSession() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 5;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        if (storeFactory instanceof AbstractSessionDataStoreFactory) {
            ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(0);
        }
        TestServer server1 = new TestServer(0, inactivePeriod, -1, (SessionCacheFactory)cacheFactory, storeFactory);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        try {
            server1.start();
            int port1 = server1.getPort();
            int scavengePeriod = 2;
            DefaultSessionCacheFactory evictCacheFactory = new DefaultSessionCacheFactory();
            TestServer server2 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)evictCacheFactory, storeFactory);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            try {
                server2.start();
                int port2 = server2.getPort();
                HttpClient client = new HttpClient();
                client.start();
                try {
                    ContentResponse response1 = client.GET("http://localhost:" + port1 + contextPath + servletMapping + "?action=init");
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    String sessionCookie = response1.getHeaders().get("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    Thread.sleep(TimeUnit.SECONDS.toMillis((long)inactivePeriod + 2L * (long)scavengePeriod));
                    Request request = client.newRequest("http://localhost:" + port2 + contextPath + servletMapping + "?action=check");
                    request.header("Cookie", sessionCookie);
                    ContentResponse response2 = request.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("A", (Object)"A");
            } else if ("remove".equals(action)) {
                HttpSession session = request.getSession(false);
                session.invalidate();
            } else if ("check".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session == null ? 1 : 0) != 0);
            }
        }
    }
}

