/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClusteredSessionMigrationTest
extends AbstractTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionMigration() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server1 = new TestServer(0, TestServer.DEFAULT_MAX_INACTIVE, TestServer.DEFAULT_SCAVENGE_SEC, (SessionCacheFactory)cacheFactory, storeFactory);
        server1.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
        try {
            server1.start();
            int port1 = server1.getPort();
            TestServer server2 = new TestServer(0, TestServer.DEFAULT_MAX_INACTIVE, TestServer.DEFAULT_SCAVENGE_SEC, (SessionCacheFactory)cacheFactory, storeFactory);
            server2.addContext(contextPath).addServlet(TestServlet.class, servletMapping);
            try {
                server2.start();
                int port2 = server2.getPort();
                HttpClient client = new HttpClient();
                client.start();
                try {
                    int value = 1;
                    Request request1 = client.POST("http://localhost:" + port1 + contextPath + servletMapping + "?action=set&value=" + value);
                    ContentResponse response1 = request1.send();
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    String sessionCookie = response1.getHeaders().get("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    Request request2 = client.newRequest("http://localhost:" + port2 + contextPath + servletMapping + "?action=get");
                    request2.header("Cookie", sessionCookie);
                    ContentResponse response2 = request2.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                    String response = response2.getContentAsString();
                    Assert.assertEquals((Object)response.trim(), (Object)String.valueOf(value));
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doPost(request, response);
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            HttpSession session = request.getSession(false);
            String action = request.getParameter("action");
            if ("set".equals(action)) {
                if (session == null) {
                    session = request.getSession(true);
                }
                int value = Integer.parseInt(request.getParameter("value"));
                session.setAttribute("value", (Object)value);
                PrintWriter writer = response.getWriter();
                writer.println(value);
                writer.flush();
            } else if ("get".equals(action)) {
                int value = (Integer)session.getAttribute("value");
                int x = session.getMaxInactiveInterval();
                Assert.assertTrue((x > 0 ? 1 : 0) != 0);
                PrintWriter writer = response.getWriter();
                writer.println(value);
                writer.flush();
            }
        }
    }
}

