/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.server.session.TestSessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractClusteredSessionScavengingTest
extends AbstractTestBase {
    public void pause(int scavengePeriod) {
        try {
            Thread.sleep((long)scavengePeriod * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoScavenging() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 3;
        int scavengePeriod = 0;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context1 = server1.addContext(contextPath);
        context1.addServlet(TestServlet.class, servletMapping);
        SessionListener listener = new SessionListener();
        context1.getSessionHandler().addEventListener((EventListener)((Object)listener));
        try {
            server1.start();
            int port1 = server1.getPort();
            HttpClient client = new HttpClient();
            client.start();
            try {
                String url = "http://localhost:" + port1 + contextPath + servletMapping;
                ContentResponse response1 = client.GET(url + "?action=init");
                Assert.assertEquals((long)200L, (long)response1.getStatus());
                String sessionCookie = response1.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                SessionHandler m1 = context1.getSessionHandler();
                Assert.assertEquals((long)1L, (long)m1.getSessionsCreated());
                this.pause(2 * inactivePeriod);
                Assert.assertEquals((long)1L, (long)m1.getSessionsCreated());
                if (m1 instanceof TestSessionHandler) {
                    ((TestSessionHandler)m1).assertCandidatesForExpiry(0);
                }
                Assert.assertEquals((long)1L, (long)listener.count.getCurrent());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalSessionsScavenging() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 4;
        int scavengePeriod = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context1 = server1.addContext(contextPath);
        context1.addServlet(TestServlet.class, servletMapping);
        try {
            server1.start();
            int port1 = server1.getPort();
            TestServer server2 = new TestServer(0, inactivePeriod, scavengePeriod * 2, (SessionCacheFactory)cacheFactory, storeFactory);
            ServletContextHandler context2 = server2.addContext(contextPath);
            context2.addServlet(TestServlet.class, servletMapping);
            try {
                server2.start();
                int port2 = server2.getPort();
                HttpClient client = new HttpClient();
                client.start();
                try {
                    String[] urls = new String[]{"http://localhost:" + port1 + contextPath + servletMapping, "http://localhost:" + port2 + contextPath + servletMapping};
                    ContentResponse response1 = client.GET(urls[0] + "?action=init");
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    String sessionCookie = response1.getHeaders().get("Set-Cookie");
                    Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                    sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                    SessionHandler m1 = context1.getSessionHandler();
                    Assert.assertEquals((long)1L, (long)m1.getSessionsCreated());
                    Request request = client.newRequest(urls[1] + "?action=test");
                    request.header("Cookie", sessionCookie);
                    ContentResponse response2 = request.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                    SessionHandler m2 = context2.getSessionHandler();
                    this.pause(inactivePeriod + 2 * scavengePeriod);
                    Assert.assertEquals((long)1L, (long)m1.getSessionsCreated());
                    request = client.newRequest(urls[0] + "?action=check");
                    request.header("Cookie", sessionCookie);
                    response1 = request.send();
                    Assert.assertEquals((long)200L, (long)response1.getStatus());
                    Assert.assertEquals((long)1L, (long)m1.getSessionsCreated());
                    this.pause(inactivePeriod + 2 * scavengePeriod);
                    request = client.newRequest(urls[1] + "?action=check");
                    request.header("Cookie", sessionCookie);
                    response2 = request.send();
                    Assert.assertEquals((long)200L, (long)response2.getStatus());
                }
                finally {
                    client.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server1.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertNotNull((Object)session);
                session.setAttribute("test", (Object)"test");
            } else if ("check".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session == null ? 1 : 0) != 0);
            }
        }
    }

    public static class SessionListener
    implements HttpSessionListener {
        public CounterStatistic count = new CounterStatistic();

        public void sessionCreated(HttpSessionEvent se) {
            this.count.increment();
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            this.count.decrement();
        }
    }
}

