/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractModifyMaxInactiveIntervalTest
extends AbstractTestBase {
    public static int newMaxInactive = 20;
    public static int __scavenge = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduceMaxInactiveInterval() throws Exception {
        int oldMaxInactive = 3;
        int newMaxInactive = 1;
        int sleep = (int)((double)oldMaxInactive * 0.8);
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive + "&wait=" + sleep);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncreaseMaxInactiveInterval() throws Exception {
        int oldMaxInactive = 3;
        int newMaxInactive = 5;
        int sleep = (int)((double)oldMaxInactive * 0.8);
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive + "&wait=" + sleep);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMaxInactiveIntervalWithImmortalSessionAndEviction() throws Exception {
        int evict;
        int oldMaxInactive = -1;
        int newMaxInactive = 120;
        int sleep = evict = 2;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(evict);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive + "&wait=" + sleep);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetMaxInactiveIntervalWithNonImmortalSessionAndEviction() throws Exception {
        int evict;
        int oldMaxInactive = 10;
        int newMaxInactive = 2;
        int sleep = evict = 4;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(evict);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive + "&wait=" + sleep);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeMaxInactiveIntervalForImmortalSessionNoEviction() throws Exception {
        int oldMaxInactive = -1;
        int newMaxInactive = 120;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive + "&wait=" + 2);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoExpireSessionInUse() throws Exception {
        int maxInactive = 3;
        int sleep = maxInactive + (int)((double)maxInactive * 0.8);
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, maxInactive, 1, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=sleep&val=" + sleep);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpiryAfterModifiedMaxInactiveInterval() throws Exception {
        int oldMaxInactive = 4;
        int newMaxInactive = 20;
        int sleep = oldMaxInactive + (int)((double)oldMaxInactive * 0.8);
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(TestServer.DEFAULT_SCAVENGE_SEC);
        TestServer server = new TestServer(0, oldMaxInactive, __scavenge, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler ctxA = server.addContext("/mod");
        ctxA.addServlet(TestModServlet.class, "/test");
        server.start();
        int port = server.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + "/mod/test?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request = client.newRequest("http://localhost:" + port + "/mod/test?action=change&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
                Thread.currentThread();
                Thread.sleep((long)sleep * 1000L);
                request = client.newRequest("http://localhost:" + port + "/mod/test?action=test&val=" + newMaxInactive);
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestModServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("create".equals(action)) {
                HttpSession session = request.getSession(true);
                return;
            }
            if ("change".equals(action)) {
                HttpSession session;
                int wait;
                String tmp = request.getParameter("val");
                int interval = -1;
                interval = tmp == null ? -1 : Integer.parseInt(tmp);
                tmp = request.getParameter("wait");
                int n = wait = tmp == null ? 0 : Integer.parseInt(tmp);
                if (wait > 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(wait * 1000);
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                if ((session = request.getSession(false)) == null) {
                    throw new ServletException("Session is null for action=change");
                }
                if (interval > 0) {
                    session.setMaxInactiveInterval(interval);
                }
                if ((session = request.getSession(false)) == null) {
                    throw new ServletException("Null session after maxInactiveInterval change");
                }
                return;
            }
            if ("sleep".equals(action)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    throw new ServletException("Session is null for action=sleep");
                }
                String tmp = request.getParameter("val");
                int interval = 0;
                int n = interval = tmp == null ? 0 : Integer.parseInt(tmp);
                if (interval > 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(interval * 1000);
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                if ((session = request.getSession(false)) == null) {
                    throw new ServletException("Session null after sleep");
                }
                return;
            }
            if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    throw new ServletException("Session does not exist");
                }
                String tmp = request.getParameter("val");
                int interval = 0;
                interval = tmp == null ? 0 : Integer.parseInt(tmp);
                Assert.assertEquals((long)interval, (long)session.getMaxInactiveInterval());
                return;
            }
        }
    }
}

