/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractNonClusteredSessionScavengingTest
extends AbstractTestBase {
    public SessionDataStore _dataStore;

    public abstract void assertSession(String var1, boolean var2);

    public void pause(int scavenge) {
        try {
            Thread.sleep((long)scavenge * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewSession() throws Exception {
        String servletMapping = "/server";
        int scavengePeriod = 3;
        int maxInactivePeriod = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server = new TestServer(0, maxInactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context = server.addContext("/");
        this._dataStore = context.getSessionHandler().getSessionCache().getSessionDataStore();
        context.addServlet(TestServlet.class, servletMapping);
        String contextPath = "";
        try {
            server.start();
            int port = server.getPort();
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + contextPath + servletMapping + "?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                this.pause(maxInactivePeriod + scavengePeriod);
                this.assertSession(TestServer.extractSessionId(sessionCookie), false);
                Request request = client.newRequest("http://localhost:" + port + contextPath + servletMapping + "?action=old-create");
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImmortalSession() throws Exception {
        String servletMapping = "/server";
        int scavengePeriod = 3;
        int maxInactivePeriod = 0;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server = new TestServer(0, maxInactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context = server.addContext("/");
        this._dataStore = context.getSessionHandler().getSessionCache().getSessionDataStore();
        context.addServlet(TestServlet.class, servletMapping);
        String contextPath = "";
        try {
            server.start();
            int port = server.getPort();
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + contextPath + servletMapping + "?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                this.pause(2 * scavengePeriod);
                this.assertSession(TestServer.extractSessionId(sessionCookie), true);
                Request request = client.newRequest("http://localhost:" + port + contextPath + servletMapping + "?action=old-test");
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        String id;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("create".equals(action)) {
                HttpSession session = request.getSession(true);
                Assert.assertTrue((boolean)session.isNew());
                this.id = session.getId();
            } else if ("old-create".equals(action)) {
                HttpSession s = request.getSession(false);
                Assert.assertNull((Object)s);
                s = request.getSession(true);
                Assert.assertNotNull((Object)s);
                Assert.assertFalse((boolean)s.getId().equals(this.id));
            } else if ("old-test".equals(action)) {
                HttpSession s = request.getSession(false);
                Assert.assertNotNull((Object)s);
                Assert.assertTrue((boolean)s.getId().equals(this.id));
            } else {
                Assert.assertTrue((boolean)false);
            }
        }
    }
}

