/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.IO;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractProxySerializationTest
extends AbstractTestBase {
    public abstract void customizeContext(ServletContextHandler var1);

    public void pause(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxySerialization() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int scavengePeriod = 10;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server = new TestServer(0, 20, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context = server.addContext(contextPath);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("proxy-serialization.jar");
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"proxy-serialization");
        testDir.mkdirs();
        File extractedJar = new File(testDir, "proxy-serialization.jar");
        extractedJar.createNewFile();
        IO.copy((InputStream)is, (OutputStream)new FileOutputStream(extractedJar));
        URLClassLoader loader = new URLClassLoader(new URL[]{extractedJar.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        context.setClassLoader((ClassLoader)loader);
        context.addServlet("TestServlet", servletMapping);
        this.customizeContext(context);
        try {
            server.start();
            int port = server.getPort();
            HttpClient client = new HttpClient();
            client.start();
            try {
                ContentResponse response = client.GET("http://localhost:" + port + contextPath + servletMapping + "?action=create");
                Assert.assertEquals((long)200L, (long)response.getStatus());
                String sessionCookie = response.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                context.stop();
                context.start();
                Request request = client.newRequest("http://localhost:" + port + contextPath + servletMapping + "?action=test");
                request.header("Cookie", sessionCookie);
                response = request.send();
                Assert.assertEquals((long)200L, (long)response.getStatus());
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }
}

