/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSessionExpiryTest
extends AbstractTestBase {
    public void pause(int period) {
        try {
            Thread.sleep((long)period * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpiresWithListener() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 3;
        int scavengePeriod = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        ServletContextHandler context = server1.addContext(contextPath);
        context.addServlet(holder, servletMapping);
        TestHttpSessionListener listener = new TestHttpSessionListener(true);
        context.getSessionHandler().addEventListener((EventListener)((Object)listener));
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentResponse response1 = client.GET(url + "?action=init");
            Assert.assertEquals((long)200L, (long)response1.getStatus());
            String sessionCookie = response1.getHeaders().get("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            String sessionId = TestServer.extractSessionId(sessionCookie);
            this.verifySessionCreated(listener, sessionId);
            this.pause(inactivePeriod + scavengePeriod * 2);
            this.verifySessionDestroyed(listener, sessionId);
            Assert.assertNull((Object)listener.ex);
        }
        finally {
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionNotExpired() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 20;
        int scavengePeriod = 10;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        server1.addContext(contextPath).addServlet(holder, servletMapping);
        HttpClient client = new HttpClient();
        try {
            server1.start();
            int port1 = server1.getPort();
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentResponse response = client.GET(url + "?action=init");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String sessionCookie = response.getHeaders().get("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            server1.stop();
            server1.start();
            port1 = server1.getPort();
            url = "http://localhost:" + port1 + contextPath + servletMapping;
            Request request = client.newRequest(url + "?action=notexpired");
            request.getHeaders().add("Cookie", sessionCookie);
            ContentResponse response2 = request.send();
            Assert.assertEquals((long)200L, (long)response2.getStatus());
        }
        finally {
            client.stop();
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionExpiry() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 4;
        int scavengePeriod = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        ServletContextHandler context = server1.addContext(contextPath);
        context.addServlet(holder, servletMapping);
        TestHttpSessionListener listener = new TestHttpSessionListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)listener));
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentResponse response1 = client.GET(url + "?action=init");
            Assert.assertEquals((long)200L, (long)response1.getStatus());
            String sessionCookie = response1.getHeaders().get("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            String sessionId = TestServer.extractSessionId(sessionCookie);
            this.verifySessionCreated(listener, sessionId);
            server1.stop();
            this.pause(inactivePeriod);
            server1.start();
            this.pause(inactivePeriod + scavengePeriod * 2);
            port1 = server1.getPort();
            url = "http://localhost:" + port1 + contextPath + servletMapping;
            Request request = client.newRequest(url + "?action=test");
            request.getHeaders().add("Cookie", sessionCookie);
            ContentResponse response2 = request.send();
            Assert.assertEquals((long)200L, (long)response2.getStatus());
            String cookie2 = response2.getHeaders().get("Set-Cookie");
            Assert.assertTrue((!cookie2.equals(sessionCookie) ? 1 : 0) != 0);
            this.verifySessionDestroyed(listener, sessionId);
        }
        finally {
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestForSessionWithChangedTimeout() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 5;
        int scavengePeriod = 1;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server1 = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ChangeTimeoutServlet servlet = new ChangeTimeoutServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        ServletContextHandler context = server1.addContext(contextPath);
        context.addServlet(holder, servletMapping);
        TestHttpSessionListener listener = new TestHttpSessionListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)listener));
        server1.start();
        int port1 = server1.getPort();
        try {
            HttpClient client = new HttpClient();
            client.start();
            String url = "http://localhost:" + port1 + contextPath + servletMapping;
            ContentResponse response = client.GET(url + "?action=init");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String sessionCookie = response.getHeaders().get("Set-Cookie");
            Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
            sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
            int newInactivePeriod = 100;
            Request request = client.newRequest(url + "?action=change&val=" + newInactivePeriod);
            request.getHeaders().add("Cookie", sessionCookie);
            response = request.send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            context.stop();
            context.start();
            this.pause(inactivePeriod);
            request = client.newRequest(url + "?action=check");
            request.getHeaders().add("Cookie", sessionCookie);
            response = request.send();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String sessionCookie2 = response.getHeaders().get("Set-Cookie");
            Assert.assertNull((Object)sessionCookie2);
        }
        finally {
            server1.stop();
        }
    }

    public void verifySessionCreated(TestHttpSessionListener listener, String sessionId) {
        Assert.assertTrue((boolean)listener.createdSessions.contains(sessionId));
    }

    public void verifySessionDestroyed(TestHttpSessionListener listener, String sessionId) {
        Assert.assertTrue((boolean)listener.destroyedSessions.contains(sessionId));
    }

    public static class ChangeTimeoutServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
            } else if ("change".equals(action)) {
                String tmp = request.getParameter("val");
                int val = StringUtil.isBlank((String)tmp) ? 0 : Integer.valueOf(tmp.trim());
                HttpSession session = request.getSession(false);
                Assert.assertNotNull((Object)session);
                session.setMaxInactiveInterval(val);
            } else if ("check".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertNotNull((Object)session);
            }
        }
    }

    public static class TestServlet
    extends HttpServlet {
        public String originalId = null;

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("test", (Object)"test");
                this.originalId = session.getId();
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(true);
                Assert.assertTrue((session != null ? 1 : 0) != 0);
                Assert.assertTrue((!this.originalId.equals(session.getId()) ? 1 : 0) != 0);
            } else if ("notexpired".equals(action)) {
                HttpSession session = request.getSession(false);
                Assert.assertTrue((session != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)this.originalId.equals(session.getId()));
            }
        }
    }

    public class TestHttpSessionListener
    implements HttpSessionListener {
        public List<String> createdSessions = new ArrayList<String>();
        public List<String> destroyedSessions = new ArrayList<String>();
        public boolean accessAttribute = false;
        public Exception ex = null;

        public TestHttpSessionListener(boolean access) {
            this.accessAttribute = access;
        }

        public TestHttpSessionListener() {
            this.accessAttribute = false;
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            this.destroyedSessions.add(se.getSession().getId());
            if (this.accessAttribute) {
                try {
                    se.getSession().getAttribute("anything");
                }
                catch (Exception e) {
                    this.ex = e;
                }
            }
        }

        public void sessionCreated(HttpSessionEvent se) {
            this.createdSessions.add(se.getSession().getId());
        }
    }
}

