/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.AbstractTestBase;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.TestServer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSessionInvalidateCreateScavengeTest
extends AbstractTestBase {
    public void pause(int scavengePeriod) {
        try {
            Thread.sleep((long)scavengePeriod * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionScavenge() throws Exception {
        String contextPath = "";
        String servletMapping = "/server";
        int inactivePeriod = 6;
        int scavengePeriod = 3;
        DefaultSessionCacheFactory cacheFactory = new DefaultSessionCacheFactory();
        cacheFactory.setEvictionPolicy(-1);
        SessionDataStoreFactory storeFactory = this.createSessionDataStoreFactory();
        ((AbstractSessionDataStoreFactory)storeFactory).setGracePeriodSec(scavengePeriod);
        TestServer server = new TestServer(0, inactivePeriod, scavengePeriod, (SessionCacheFactory)cacheFactory, storeFactory);
        ServletContextHandler context = server.addContext(contextPath);
        TestServlet servlet = new TestServlet();
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        context.addServlet(holder, servletMapping);
        MySessionListener listener = new MySessionListener();
        context.getSessionHandler().addEventListener((EventListener)((Object)listener));
        try {
            server.start();
            int port1 = server.getPort();
            HttpClient client = new HttpClient();
            client.start();
            try {
                String url = "http://localhost:" + port1 + contextPath + servletMapping;
                ContentResponse response1 = client.GET(url + "?action=init");
                Assert.assertEquals((long)200L, (long)response1.getStatus());
                String sessionCookie = response1.getHeaders().get("Set-Cookie");
                Assert.assertTrue((sessionCookie != null ? 1 : 0) != 0);
                sessionCookie = sessionCookie.replaceFirst("(\\W)(P|p)ath=", "$1\\$Path=");
                Request request2 = client.newRequest(url + "?action=test");
                request2.header("Cookie", sessionCookie);
                ContentResponse response2 = request2.send();
                Assert.assertEquals((long)200L, (long)response2.getStatus());
                this.pause(inactivePeriod + 2 * scavengePeriod);
                Assert.assertTrue((listener.destroys.size() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((listener.destroys.get(0) != listener.destroys.get(1) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)servlet.listener.unbound);
            }
            finally {
                client.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    public static class TestServlet
    extends HttpServlet {
        public MySessionBindingListener listener = new MySessionBindingListener();

        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String action = request.getParameter("action");
            if ("init".equals(action)) {
                HttpSession session = request.getSession(true);
                session.setAttribute("identity", (Object)"session1");
                session.setMaxInactiveInterval(-1);
            } else if ("test".equals(action)) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    String oldId = session.getId();
                    session.invalidate();
                    try {
                        session.getAttribute("identity");
                        Assert.fail((String)"Session should be invalid");
                    }
                    catch (IllegalStateException e) {
                        Assert.assertNotNull((Object)e.getMessage());
                        Assert.assertTrue((boolean)e.getMessage().contains("id"));
                    }
                    session = request.getSession(true);
                    String newId = session.getId();
                    Assert.assertTrue((!newId.equals(oldId) ? 1 : 0) != 0);
                    Assert.assertTrue((session.getAttribute("identity") == null ? 1 : 0) != 0);
                    session.setAttribute("identity", (Object)"session2");
                    session.setAttribute("listener", (Object)this.listener);
                } else {
                    Assert.fail((String)"Session already missing");
                }
            }
        }
    }

    public static class MySessionBindingListener
    implements HttpSessionBindingListener,
    Serializable {
        private boolean unbound = false;

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.unbound = true;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }
    }

    public static class Foo
    implements Serializable {
        public boolean bar = false;

        public boolean getBar() {
            return this.bar;
        }
    }

    public class MySessionListener
    implements HttpSessionListener {
        List<Integer> destroys = new ArrayList<Integer>();

        public void sessionCreated(HttpSessionEvent e) {
        }

        public void sessionDestroyed(HttpSessionEvent e) {
            this.destroys.add(e.getSession().hashCode());
        }
    }
}

