/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.HouseKeeper;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionCacheFactory;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class TestServer {
    public static int DEFAULT_MAX_INACTIVE = 30;
    public static int DEFAULT_SCAVENGE_SEC = 10;
    public static int DEFAULT_EVICTIONPOLICY = -1;
    protected static int __workers = 0;
    protected final Server _server;
    protected final int _maxInactivePeriod;
    protected final int _scavengePeriod;
    protected final ContextHandlerCollection _contexts;
    protected SessionIdManager _sessionIdManager;
    private HouseKeeper _housekeeper;
    protected Object _config;
    protected SessionCacheFactory _cacheFactory;
    protected SessionDataStoreFactory _storeFactory;

    public static String extractSessionId(String sessionCookie) {
        if (sessionCookie == null) {
            return null;
        }
        int i = (sessionCookie = sessionCookie.trim()).indexOf(59);
        if (i >= 0) {
            sessionCookie = sessionCookie.substring(0, i);
        }
        if (sessionCookie.startsWith("JSESSIONID")) {
            sessionCookie = sessionCookie.substring("JSESSIONID=".length());
        }
        if ((i = sessionCookie.indexOf(46)) >= 0) {
            sessionCookie = sessionCookie.substring(0, i);
        }
        return sessionCookie;
    }

    public TestServer(int port, int maxInactivePeriod, int scavengePeriod, SessionCacheFactory cacheFactory, SessionDataStoreFactory storeFactory) throws Exception {
        this._server = new Server(port);
        this._maxInactivePeriod = maxInactivePeriod;
        this._scavengePeriod = scavengePeriod;
        this._cacheFactory = cacheFactory;
        this._storeFactory = storeFactory;
        this._contexts = new ContextHandlerCollection();
        this._sessionIdManager = this.newSessionIdManager();
        this._server.setSessionIdManager(this._sessionIdManager);
        ((DefaultSessionIdManager)this._sessionIdManager).setServer(this._server);
        this._housekeeper = new HouseKeeper();
        this._housekeeper.setIntervalSec((long)this._scavengePeriod);
        ((DefaultSessionIdManager)this._sessionIdManager).setSessionHouseKeeper(this._housekeeper);
    }

    public SessionIdManager newSessionIdManager() {
        DefaultSessionIdManager idManager = new DefaultSessionIdManager(this.getServer());
        idManager.setWorkerName("w" + __workers++);
        return idManager;
    }

    public SessionHandler newSessionHandler() throws Exception {
        SessionHandler h = new SessionHandler();
        SessionCache c = this._cacheFactory.getSessionCache(h);
        SessionDataStore s = this._storeFactory.getSessionDataStore(h);
        c.setSessionDataStore(s);
        h.setSessionCache(c);
        return h;
    }

    public void start() throws Exception {
        this._server.setHandler((Handler)this._contexts);
        this._server.start();
    }

    public HouseKeeper getHouseKeeper() {
        return this._housekeeper;
    }

    public int getPort() {
        return ((NetworkConnector)this.getServer().getConnectors()[0]).getLocalPort();
    }

    public ServletContextHandler addContext(String contextPath) throws Exception {
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this._contexts, contextPath);
        SessionHandler sessionHandler = this.newSessionHandler();
        sessionHandler.setSessionIdManager(this._sessionIdManager);
        sessionHandler.setMaxInactiveInterval(this._maxInactivePeriod);
        context.setSessionHandler(sessionHandler);
        return context;
    }

    public void stop() throws Exception {
        this._server.stop();
    }

    public WebAppContext addWebAppContext(String warPath, String contextPath) throws Exception {
        WebAppContext context = new WebAppContext((HandlerContainer)this._contexts, warPath, contextPath);
        SessionHandler sessionHandler = this.newSessionHandler();
        sessionHandler.setSessionIdManager(this._sessionIdManager);
        sessionHandler.setMaxInactiveInterval(this._maxInactivePeriod);
        context.setSessionHandler(sessionHandler);
        return context;
    }

    public Server getServer() {
        return this._server;
    }
}

