/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionData;

public class TestSessionDataStore
extends AbstractSessionDataStore {
    public Map<String, SessionData> _map = new HashMap<String, SessionData>();

    public boolean isPassivating() {
        return false;
    }

    public boolean exists(String id) throws Exception {
        return this._map.containsKey(id);
    }

    public SessionData load(String id) throws Exception {
        SessionData sd = this._map.get(id);
        if (sd == null) {
            return null;
        }
        SessionData nsd = new SessionData(id, "", "", System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis(), 0L);
        nsd.copy(sd);
        return nsd;
    }

    public boolean delete(String id) throws Exception {
        return this._map.remove(id) != null;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        this._map.put(id, data);
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        HashSet<String> set = new HashSet<String>();
        long now = System.currentTimeMillis();
        for (SessionData d : this._map.values()) {
            if (d.getExpiry() <= 0L || d.getExpiry() > now) continue;
            set.add(d.getId());
        }
        return set;
    }
}

