/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.modifysources;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.toolchain.modifysources.ModifyEE9ToEE8;

@Mojo(name="modify-service-loader-files-ee9-to-ee8", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ModifyEE9ToEE8ServiceLoaderFiles
extends AbstractMojo {
    @Parameter(property="jetty.modifysources.servicesloader.files.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    private List<String> extraFileNames = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"EE9toEE8 skip");
            return;
        }
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"EE9toEE8 skip pom packaging");
            return;
        }
        try {
            File metaInfDirectory = new File(this.outputDirectory, "META-INF/services");
            String[] files = metaInfDirectory.list((dir, name) -> StringUtils.startsWith((CharSequence)name, (CharSequence)"org.eclipse.jetty.ee9") || StringUtils.startsWith((CharSequence)name, (CharSequence)"jakarta.") || this.extraFileNames.contains(name));
            if (files == null) {
                return;
            }
            for (String fileName : files) {
                File file = new File(metaInfDirectory, fileName);
                String newFileName = ModifyEE9ToEE8.changeEE9TypeToEE8(fileName);
                File newFile = new File(metaInfDirectory, newFileName == null ? fileName : newFileName);
                List newContent = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8).stream().map(s -> this.mapFileName((String)s)).collect(Collectors.toList());
                Files.write(newFile.toPath(), newContent, StandardCharsets.UTF_8, new OpenOption[0]);
                if (newFileName == null) continue;
                Files.delete(file.toPath());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("fail to modify jetty sources", (Exception)e);
        }
    }

    private String mapFileName(String className) {
        String newType = ModifyEE9ToEE8.changeEE9TypeToEE8(className);
        return newType == null ? className : newType;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

