/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.matchers;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;

public class IsOrderedCollectionContaining<T>
extends BaseMatcher<List<? super T>> {
    private final List<T> expectedList;
    private String failureReason;
    private List<Integer> badEntries = new ArrayList<Integer>();
    private MismatchDescription actualFailureDescription;
    private MismatchDescription expectedFailureDescription;

    public IsOrderedCollectionContaining(List<T> expectedList) {
        this.expectedList = expectedList;
    }

    public boolean matches(Object collection) {
        int i;
        if (collection == null) {
            this.failureReason = "is <null>";
            return false;
        }
        if (!(collection instanceof List)) {
            this.failureReason = "is not an instance of " + List.class.getName();
            return false;
        }
        List actualList = (List)collection;
        boolean sizeMismatch = this.expectedList.size() != actualList.size();
        this.badEntries = new ArrayList<Integer>();
        int min = Math.min(this.expectedList.size(), actualList.size());
        int max = Math.max(this.expectedList.size(), actualList.size());
        for (i = 0; i < min; ++i) {
            if (this.expectedList.get(i).equals(actualList.get(i))) continue;
            this.badEntries.add(i);
        }
        for (i = min; i < max; ++i) {
            this.badEntries.add(i);
        }
        if (sizeMismatch || this.badEntries.size() > 0) {
            if (sizeMismatch) {
                this.failureReason = String.format("size mismatch: expected <%d> entries, but got <%d> entries instead", this.expectedList.size(), actualList.size());
            } else if (this.badEntries.size() > 0) {
                this.failureReason = String.format("<%d> entr%s not matched", this.badEntries.size(), this.badEntries.size() > 1 ? "ies" : "y");
                this.actualFailureDescription = new MismatchDescription("Actual", actualList);
                this.expectedFailureDescription = new MismatchDescription("Expected", this.expectedList);
            }
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        if (this.expectedFailureDescription != null) {
            description.appendDescriptionOf((SelfDescribing)this.expectedFailureDescription);
        }
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText(this.failureReason);
        if (this.actualFailureDescription != null) {
            description.appendText(System.lineSeparator());
            description.appendDescriptionOf((SelfDescribing)this.actualFailureDescription);
        }
    }

    private class MismatchDescription
    implements SelfDescribing {
        private final String id;
        private final List<T> entries;

        public MismatchDescription(String id, List<T> entries) {
            this.id = id;
            this.entries = entries;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("%s Entries (size: %d)", this.id, this.entries.size()));
            for (int i = 0; i < this.entries.size(); ++i) {
                Object actualObj = this.entries.get(i);
                char indicator = IsOrderedCollectionContaining.this.badEntries.contains(i) ? (char)'>' : ' ';
                description.appendText(String.format("%n%s[%d] %s", Character.valueOf(indicator), i, actualObj == null ? "<null>" : actualObj.toString()));
            }
        }
    }
}

