/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.toolchain.test.PathMatchers;
import org.eclipse.jetty.toolchain.test.StringMangler;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class MavenPaths {
    private static Path basePath;

    public static Path projectBase() {
        if (basePath == null) {
            for (String propName : List.of("project.basedir", "basedir", "user.dir")) {
                Path dir;
                String propDir = System.getProperty(propName);
                if (propDir == null || !Files.exists(dir = Paths.get(propDir, new String[0]), new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
                basePath = MavenPaths.absolute(dir);
                return basePath;
            }
            throw new IllegalStateException("Java has no Current Working Directory: System.getProperty(\"user.dir\") = " + System.getProperty("user.dir"));
        }
        return basePath;
    }

    public static Path targetDir() {
        Path targetDir = MavenPaths.projectBase().resolve("target");
        MatcherAssert.assertThat((String)"Target Dir", (Object)targetDir, PathMatchers.isDirectory());
        return targetDir;
    }

    public static Path targetTests() {
        Path testsDir = MavenPaths.targetDir().resolve("tests");
        if (!Files.exists(testsDir, new LinkOption[0])) {
            try {
                Files.createDirectory(testsDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create required directory: " + testsDir, e);
            }
        }
        MatcherAssert.assertThat((String)"Tests Dir", (Object)testsDir, PathMatchers.isDirectory());
        return testsDir;
    }

    public static Path targetTestDir(ExtensionContext context) {
        Objects.requireNonNull(context);
        if (!context.getTestInstance().isPresent()) {
            throw new AssertionError((Object)"ExtensionContext is invalid");
        }
        String methodName = null;
        if (context.getTestMethod().isPresent()) {
            methodName = ((Method)context.getTestMethod().get()).getName();
        }
        Object obj = context.getTestInstance().get();
        Class<?> testClazz = context.getTestClass().orElse(obj.getClass());
        return MavenPaths.targetTestDir(testClazz, methodName, context.getDisplayName());
    }

    public static Path targetTestDir(TestInfo info) {
        Objects.requireNonNull(info);
        if (info.getTestClass().isPresent()) {
            throw new AssertionError((Object)"TestInfo is invalid");
        }
        String methodName = null;
        if (info.getTestMethod().isPresent()) {
            methodName = ((Method)info.getTestMethod().get()).getName();
        }
        Class testClazz = (Class)info.getTestClass().get();
        return MavenPaths.targetTestDir(testClazz, methodName, info.getDisplayName());
    }

    public static Path targetTestDir(String name) {
        Path path = MavenPaths.targetTests().resolve(name);
        if (Files.exists(path, new LinkOption[0])) {
            MatcherAssert.assertThat((String)"Test Directory", (Object)path, PathMatchers.isDirectory());
        }
        return path;
    }

    public static Path targetTestDir(Class<?> testClazz, String methodName, String displayName) {
        Objects.requireNonNull(testClazz, "Class name");
        Objects.requireNonNull(displayName, "Display name");
        StringBuilder dirName = new StringBuilder();
        dirName.append(StringMangler.condensePackageString(testClazz.getName()));
        dirName.append(File.separatorChar);
        if (methodName != null) {
            if (OS.WINDOWS.isCurrentOs()) {
                dirName.append(StringMangler.maxStringLength(30, methodName));
            } else {
                dirName.append(methodName);
            }
            if (!displayName.startsWith(methodName)) {
                dirName.append(MavenPaths.safename(displayName.trim()));
            }
        } else {
            dirName.append(MavenPaths.safename(displayName.trim()));
        }
        return MavenPaths.targetTestDir(dirName.toString());
    }

    public static Path findMainResourceFile(String name) {
        Path path = MavenPaths.findMainResource(name);
        String msg = String.format("findMainResourceFile(\"%s\")", name);
        MatcherAssert.assertThat((String)msg, (Object)path, PathMatchers.isRegularFile());
        return path;
    }

    public static Path findMainResourceDir(String name) {
        Path path = MavenPaths.findMainResource(name);
        String msg = String.format("findMainResourceDir(\"%s\")", name);
        MatcherAssert.assertThat((String)msg, (Object)path, PathMatchers.isDirectory());
        return path;
    }

    public static Path findTestResourceFile(String name) {
        Path path = MavenPaths.findTestResource(name);
        String msg = String.format("findTestResourceFile(\"%s\")", name);
        MatcherAssert.assertThat((String)msg, (Object)path, PathMatchers.isRegularFile());
        return path;
    }

    public static Path findTestResourceDir(String name) {
        Path path = MavenPaths.findTestResource(name);
        String msg = String.format("findTestResourceDir(\"%s\")", name);
        MatcherAssert.assertThat((String)msg, (Object)path, PathMatchers.isDirectory());
        return path;
    }

    private static Path absolute(Path path) {
        Path result;
        try {
            result = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            result = path.toAbsolutePath();
        }
        return result;
    }

    private static Path findMainResource(String name) {
        Path srcMainPath = MavenPaths.projectBase().resolve("src/main/resources/" + name);
        if (Files.exists(srcMainPath, new LinkOption[0])) {
            return srcMainPath;
        }
        Path targetClassesPath = MavenPaths.projectBase().resolve("target/classes/" + name);
        if (Files.exists(targetClassesPath, new LinkOption[0])) {
            return targetClassesPath;
        }
        return null;
    }

    private static Path findTestResource(String name) {
        Path classLoaderPath;
        URI uri;
        Path srcMainPath = MavenPaths.projectBase().resolve("src/test/resources/" + name);
        if (Files.exists(srcMainPath, new LinkOption[0])) {
            return srcMainPath;
        }
        Path targetClassesPath = MavenPaths.projectBase().resolve("target/test-classes/" + name);
        if (Files.exists(targetClassesPath, new LinkOption[0])) {
            return targetClassesPath;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL classLoaderUrl = classLoader.getResource(name);
        if (classLoaderUrl != null && "file".equals((uri = URI.create(classLoaderUrl.toExternalForm())).getScheme()) && Files.exists(classLoaderPath = Paths.get(uri), new LinkOption[0])) {
            return classLoaderPath;
        }
        return null;
    }

    static String safename(String name) {
        String reserved = " []<>/:\"|\\?*\u007f";
        StringBuilder result = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (Character.isISOControl(c) || " []<>/:\"|\\?*\u007f".indexOf(c) >= 0) {
                result.append(String.format("%%%02X", (byte)(c & 0xFF)));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

