/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test.jupiter;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.eclipse.jetty.toolchain.test.MavenPaths;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class WorkDirExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    public void beforeAll(ExtensionContext context) {
        this.injectStaticFields(context, context.getRequiredTestClass());
    }

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectInstanceFields(context, instance));
    }

    private void injectStaticFields(ExtensionContext context, Class<?> testClass) {
        this.injectFields(context, null, testClass, ReflectionUtils::isStatic);
    }

    private void injectInstanceFields(ExtensionContext context, Object instance) {
        this.injectFields(context, instance, instance.getClass(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass, Predicate<Field> fieldPredicate) {
        if (!context.getTestInstance().isPresent()) {
            return;
        }
        Path testPath = MavenPaths.targetTestDir(context);
        WorkDir workdir = new WorkDir(testPath);
        Predicate<Field> isWorkDirAssignable = f -> WorkDir.class.isAssignableFrom(f.getType());
        ReflectionUtils.findFields(testClass, fieldPredicate.and(isWorkDirAssignable), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            this.assertValidFieldCandidate((Field)field);
            try {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(testInstance, workdir);
            }
            catch (Throwable t) {
                t.printStackTrace();
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    private void assertValidFieldCandidate(Field field) {
        if (ReflectionUtils.isPrivate((Member)field)) {
            throw new ExtensionConfigurationException("WorkDir field [" + field + "] must not be private.");
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return WorkDir.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> clazz = parameterContext.getDeclaringExecutable().getDeclaringClass();
        String methodName = null;
        if (extensionContext.getTestInstance().isPresent()) {
            methodName = ((Method)extensionContext.getTestMethod().get()).getName();
        }
        String displayName = extensionContext.getDisplayName();
        Path dir = MavenPaths.targetTestDir(clazz, methodName, displayName);
        return new WorkDir(dir);
    }
}

