/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.UpdateVersionTextMojo;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.git.GitCommand;
import org.eclipse.jetty.toolchain.version.issues.Issue;
import org.eclipse.jetty.toolchain.version.issues.IssueComparator;

public class ChangesMojo
extends UpdateVersionTextMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.hasVersionTextFile("changes")) {
            return;
        }
        try {
            String currentTagId;
            String priorTextVersion;
            VersionPattern verTextPattern = new VersionPattern(this.versionTextKey);
            VersionPattern verTagPattern = new VersionPattern(this.versionTagKey);
            VersionText versionText = new VersionText(verTextPattern);
            versionText.read(this.versionTextInputFile);
            String updateVersionText = verTextPattern.toVersionId(this.version);
            String updateVersionGit = verTagPattern.toVersionId(this.version);
            this.getLog().debug((CharSequence)("raw version = " + this.version));
            this.getLog().debug((CharSequence)("updateVersionText (as it appears in VERSION.txt) = " + updateVersionText));
            this.getLog().debug((CharSequence)("updateVersionGit (as it appears to git tags) = " + updateVersionGit));
            Release rel = versionText.findRelease(updateVersionText);
            if (rel == null) {
                rel = new Release(updateVersionText);
            }
            if ((priorTextVersion = versionText.getPriorVersion(updateVersionText)) == null) {
                priorTextVersion = versionText.getReleases().get(0).getVersion();
            }
            this.getLog().debug((CharSequence)("Prior version in VERSION.txt is " + priorTextVersion));
            GitCommand git = new GitCommand();
            git.setWorkDir(this.basedir);
            git.setLog(this.getLog());
            if (this.refreshTags) {
                this.getLog().info((CharSequence)"Fetching git tags from remote ...");
                if (!git.fetchTags()) {
                    throw new MojoFailureException("Unable to fetch git tags?");
                }
            }
            if (!verTextPattern.isMatch(priorTextVersion)) {
                StringBuilder err = new StringBuilder();
                err.append("Prior version [").append(priorTextVersion);
                err.append("] is not a valid version identifier.");
                err.append(" Does not conform to expected pattern [");
                err.append(this.versionTextKey).append("]");
                throw new MojoExecutionException(err.toString());
            }
            String priorGitVersion = verTextPattern.getLastVersion(this.versionTagKey);
            String priorTagId = git.findTagMatching(priorGitVersion);
            if (priorTagId == null) {
                this.getLog().warn((CharSequence)("Unable to find git tag id for prior version id [" + priorGitVersion + "] (defined in VERSION.txt as [" + priorTextVersion + "])"));
                return;
            }
            this.getLog().debug((CharSequence)("Tag for prior version [" + priorGitVersion + "] is " + priorTagId));
            String priorCommitId = git.getTagCommitId(priorTagId);
            this.getLog().debug((CharSequence)("Commit ID from [" + priorTagId + "]: " + priorCommitId));
            String currentCommitId = "HEAD";
            if (this.refreshTags && (currentTagId = git.findTagMatching(updateVersionText)) != null) {
                currentCommitId = git.getTagCommitId(currentTagId);
            }
            this.getLog().debug((CharSequence)("Commit ID to [" + updateVersionText + "]: " + currentCommitId));
            git.populateIssuesForRange(priorCommitId, currentCommitId, rel);
            this.resolveIssueSubjects(rel);
            ArrayList<Issue> issues = new ArrayList<Issue>();
            issues.addAll(rel.getIssues());
            Collections.sort(issues, new IssueComparator());
            System.out.printf("Changes from %s [%s]%n", priorTagId, priorCommitId);
            System.out.printf("          to %s%n", currentCommitId);
            System.out.println();
            for (Issue issue : issues) {
                System.out.println(issue);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to obtain changes", (Throwable)e);
        }
    }
}

