/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.logging.Log;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.extras.OkHttpConnector;

public class GitHubIssueResolver {
    private Log log;
    private String repoName = "eclipse/jetty.project";
    private Path cacheDirectory;
    private GitHub github;

    public void init(Log log) throws IOException {
        this.log = log;
        Path userHome = new File(System.getProperty("user.home")).toPath();
        this.cacheDirectory = userHome.resolve(".cache/github/jetty");
        if (!Files.exists(this.cacheDirectory, new LinkOption[0])) {
            Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
        }
        Cache cache = new Cache(this.cacheDirectory.toFile(), 0xA00000L);
        this.github = GitHubBuilder.fromCredentials().withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(new OkHttpClient().setCache(cache)))).build();
        if (!this.github.isCredentialValid()) {
            this.github = null;
            throw new IOException("Unable to access github, invalid credentials in ~/.github ?");
        }
        log.info((CharSequence)("Github API Rate Limits: " + this.github.getRateLimit().toString()));
    }

    public GHIssue getIssue(String issueRef) throws IOException {
        int issueNum = Integer.parseInt(issueRef);
        try {
            return this.github.getRepository(this.repoName).getIssue(issueNum);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return null;
        }
    }

    public void destroy() {
        try {
            if (this.github != null) {
                this.log.info((CharSequence)("Github Rate Limit: " + this.github.getRateLimit()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

