/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.xhtml;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.catalog.Catalog;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;

public final class CatalogXHTML {
    private static final String CATALOG_XHTML_XML = "catalog-xhtml.xml";

    public static URI getURI() {
        URL url = CatalogXHTML.class.getResource(CATALOG_XHTML_XML);
        if (url == null) {
            throw new IllegalStateException("Unable to find: catalog-xhtml.xml");
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to convert URL to URI", e);
        }
    }

    @Deprecated
    public static Catalog getCatalog() {
        return CatalogXHTML.getCatalog("continue");
    }

    public static Catalog getCatalogStrict() {
        return CatalogXHTML.getCatalog("strict");
    }

    public static Catalog getCatalog(String resolveMode) {
        CatalogFeatures f = CatalogFeatures.builder().with(CatalogFeatures.Feature.RESOLVE, resolveMode).build();
        return CatalogManager.catalog(f, CatalogXHTML.getURI());
    }
}

