/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.javax.common.BasicEndpointConfig;
import org.eclipse.jetty.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.javax.common.InvalidWebSocketException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.MessageSink;
import org.eclipse.jetty.websocket.javax.common.UpgradeRequest;
import org.eclipse.jetty.websocket.javax.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.javax.common.messages.ByteArrayMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.InputStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialByteArrayMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.PartialStringMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.ReaderMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.StringMessageSink;
import org.eclipse.jetty.websocket.javax.common.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.javax.common.util.InvokerUtils;
import org.eclipse.jetty.websocket.javax.common.util.ReflectUtils;

public abstract class JavaxWebSocketFrameHandlerFactory {
    private static final MethodHandle FILTER_RETURN_TYPE_METHOD;
    protected final JavaxWebSocketContainer container;
    protected final InvokerUtils.ParamIdentifier paramIdentifier;
    private Map<Class<?>, JavaxWebSocketFrameHandlerMetadata> metadataMap = new ConcurrentHashMap();

    public JavaxWebSocketFrameHandlerFactory(JavaxWebSocketContainer container, InvokerUtils.ParamIdentifier paramIdentifier) {
        this.container = container;
        this.paramIdentifier = paramIdentifier == null ? InvokerUtils.PARAM_IDENTITY : paramIdentifier;
    }

    public JavaxWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        JavaxWebSocketFrameHandlerMetadata metadata = this.metadataMap.get(endpointClass);
        if (metadata == null) {
            metadata = this.createMetadata(endpointClass, endpointConfig);
            this.metadataMap.put(endpointClass, metadata);
        }
        return metadata;
    }

    public abstract JavaxWebSocketFrameHandlerMetadata createMetadata(Class<?> var1, EndpointConfig var2);

    public JavaxWebSocketFrameHandler newJavaxWebSocketFrameHandler(Object endpointInstance, UpgradeRequest upgradeRequest) {
        BasicEndpointConfig config;
        Object endpoint;
        if (endpointInstance instanceof ConfiguredEndpoint) {
            ConfiguredEndpoint configuredEndpoint = (ConfiguredEndpoint)endpointInstance;
            endpoint = configuredEndpoint.getRawEndpoint();
            config = configuredEndpoint.getConfig();
        } else {
            endpoint = endpointInstance;
            config = new BasicEndpointConfig();
        }
        JavaxWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpoint.getClass(), config);
        if (metadata == null) {
            return null;
        }
        MethodHandle openHandle = metadata.getOpenHandle();
        MethodHandle closeHandle = metadata.getCloseHandle();
        MethodHandle errorHandle = metadata.getErrorHandle();
        MethodHandle pongHandle = metadata.getPongHandle();
        JavaxWebSocketFrameHandlerMetadata.MessageMetadata textMetadata = JavaxWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(metadata.getTextMetadata());
        JavaxWebSocketFrameHandlerMetadata.MessageMetadata binaryMetadata = JavaxWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(metadata.getBinaryMetadata());
        UriTemplatePathSpec templatePathSpec = metadata.getUriTemplatePathSpec();
        if (templatePathSpec != null) {
            String[] namedVariables = templatePathSpec.getVariables();
            Map pathParams = templatePathSpec.getPathParams(upgradeRequest.getRequestURI().getRawPath());
            openHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(openHandle, namedVariables, pathParams);
            closeHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(closeHandle, namedVariables, pathParams);
            errorHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(errorHandle, namedVariables, pathParams);
            pongHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(pongHandle, namedVariables, pathParams);
            if (textMetadata != null) {
                textMetadata.handle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(textMetadata.handle, namedVariables, pathParams);
            }
            if (binaryMetadata != null) {
                binaryMetadata.handle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(binaryMetadata.handle, namedVariables, pathParams);
            }
        }
        openHandle = InvokerUtils.bindTo(openHandle, endpoint);
        closeHandle = InvokerUtils.bindTo(closeHandle, endpoint);
        errorHandle = InvokerUtils.bindTo(errorHandle, endpoint);
        pongHandle = InvokerUtils.bindTo(pongHandle, endpoint);
        JavaxWebSocketFrameHandler frameHandler = new JavaxWebSocketFrameHandler(this.container, endpoint, openHandle, closeHandle, errorHandle, textMetadata, binaryMetadata, pongHandle, config);
        return frameHandler;
    }

    public static MethodHandle bindTemplateVariables(MethodHandle target, String[] namedVariables, Map<String, String> templateValues) {
        if (target == null) {
            return null;
        }
        boolean IDX = true;
        MethodHandle retHandle = target;
        if (templateValues == null || templateValues.isEmpty()) {
            return retHandle;
        }
        for (String variableName : namedVariables) {
            String strValue = templateValues.get(variableName);
            TypeDescriptor.OfField type = retHandle.type().parameterType(1);
            try {
                if (String.class.isAssignableFrom((Class<?>)type)) {
                    retHandle = MethodHandles.insertArguments(retHandle, 1, strValue);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom((Class<?>)type)) {
                    int intValue = Integer.parseInt(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, intValue);
                    continue;
                }
                if (Long.TYPE.isAssignableFrom((Class<?>)type)) {
                    long longValue = Long.parseLong(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, longValue);
                    continue;
                }
                if (Short.TYPE.isAssignableFrom((Class<?>)type)) {
                    short shortValue = Short.parseShort(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, shortValue);
                    continue;
                }
                if (Float.TYPE.isAssignableFrom((Class<?>)type)) {
                    float floatValue = Float.parseFloat(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, Float.valueOf(floatValue));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom((Class<?>)type)) {
                    double doubleValue = Double.parseDouble(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, doubleValue);
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom((Class<?>)type)) {
                    boolean boolValue = Boolean.parseBoolean(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, boolValue);
                    continue;
                }
                if (Character.TYPE.isAssignableFrom((Class<?>)type)) {
                    if (strValue.length() != 1) {
                        throw new IllegalArgumentException("Invalid Size");
                    }
                    char charValue = strValue.charAt(0);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, Character.valueOf(charValue));
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom((Class<?>)type)) {
                    byte[] buf = strValue.getBytes(StandardCharsets.UTF_8);
                    if (buf.length != 1) {
                        throw new IllegalArgumentException("Invalid Size");
                    }
                    retHandle = MethodHandles.insertArguments(retHandle, 1, buf[0]);
                    continue;
                }
                throw new IllegalStateException("Unsupported Type: " + (Class)type);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage());
            }
        }
        return retHandle;
    }

    public static MessageSink createMessageSink(JavaxWebSocketSession session, JavaxWebSocketFrameHandlerMetadata.MessageMetadata msgMetadata) {
        if (msgMetadata == null) {
            return null;
        }
        try {
            if (DecodedMessageSink.class.isAssignableFrom(msgMetadata.sinkClass)) {
                MethodHandle ctorHandle = MethodHandles.lookup().findConstructor(msgMetadata.sinkClass, MethodType.methodType(Void.TYPE, JavaxWebSocketSession.class, msgMetadata.registeredDecoder.interfaceType, MethodHandle.class));
                Object decoder = session.getDecoders().getInstanceOf(msgMetadata.registeredDecoder);
                return ctorHandle.invoke(session, (Decoder)decoder, msgMetadata.handle);
            }
            MethodHandle ctorHandle = MethodHandles.lookup().findConstructor(msgMetadata.sinkClass, MethodType.methodType(Void.TYPE, JavaxWebSocketSession.class, MethodHandle.class));
            return ctorHandle.invoke(session, msgMetadata.handle);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing expected MessageSink constructor found at: " + msgMetadata.sinkClass.getName(), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create MessageSink: " + msgMetadata.sinkClass.getName(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static MethodHandle wrapNonVoidReturnType(MethodHandle handle, JavaxWebSocketSession session) throws NoSuchMethodException, IllegalAccessException {
        if (handle == null) {
            return null;
        }
        if (handle.type().returnType() == Void.TYPE) {
            return handle;
        }
        handle = handle.asType(handle.type().changeReturnType(Object.class));
        handle = MethodHandles.filterReturnValue(handle, FILTER_RETURN_TYPE_METHOD.bindTo((Object)session));
        return handle;
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + method, e);
        }
    }

    protected JavaxWebSocketFrameHandlerMetadata createEndpointMetadata(Class<? extends Endpoint> endpointClass, EndpointConfig endpointConfig) {
        JavaxWebSocketFrameHandlerMetadata metadata = new JavaxWebSocketFrameHandlerMetadata(endpointConfig);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Method openMethod = ReflectUtils.findMethod(endpointClass, "onOpen", Session.class, EndpointConfig.class);
        MethodHandle open = this.toMethodHandle(lookup, openMethod);
        metadata.setOpenHandler(open, openMethod);
        Method closeMethod = ReflectUtils.findMethod(endpointClass, "onClose", Session.class, CloseReason.class);
        MethodHandle close = this.toMethodHandle(lookup, closeMethod);
        metadata.setCloseHandler(close, closeMethod);
        Method errorMethod = ReflectUtils.findMethod(endpointClass, "onError", Session.class, Throwable.class);
        MethodHandle error = this.toMethodHandle(lookup, errorMethod);
        metadata.setErrorHandler(error, errorMethod);
        return metadata;
    }

    protected JavaxWebSocketFrameHandlerMetadata discoverJavaxFrameHandlerMetadata(Class<?> endpointClass, JavaxWebSocketFrameHandlerMetadata metadata) {
        Method[] onMessages;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnOpen.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnOpen.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg ENDPOINT_CONFIG = new InvokerUtils.Arg(EndpointConfig.class);
            methodHandle = InvokerUtils.mutatedInvoker(endpointClass, onmethod, this.paramIdentifier, metadata.getNamedTemplateVariables(), SESSION, ENDPOINT_CONFIG);
            metadata.setOpenHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CLOSE_REASON = new InvokerUtils.Arg(CloseReason.class);
            methodHandle = InvokerUtils.mutatedInvoker(endpointClass, onmethod, this.paramIdentifier, metadata.getNamedTemplateVariables(), SESSION, CLOSE_REASON);
            metadata.setCloseHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            methodHandle = InvokerUtils.mutatedInvoker(endpointClass, onmethod, this.paramIdentifier, metadata.getNamedTemplateVariables(), SESSION, CAUSE);
            metadata.setErrorHandler(methodHandle, onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnMessage.class)) != null && onMessages.length > 0) {
            InvokerUtils.Arg[] textCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required()};
            InvokerUtils.Arg[] textPartialCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
            InvokerUtils.Arg[] binaryBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required()};
            InvokerUtils.Arg[] binaryPartialBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
            InvokerUtils.Arg[] binaryArrayCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(byte[].class).required()};
            InvokerUtils.Arg[] binaryPartialArrayCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(byte[].class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
            InvokerUtils.Arg[] inputStreamCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(InputStream.class).required()};
            InvokerUtils.Arg[] readerCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(Reader.class).required()};
            InvokerUtils.Arg[] pongCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(PongMessage.class).required()};
            ArrayList<DecodedArgs> decodedTextCallingArgs = new ArrayList<DecodedArgs>();
            ArrayList<DecodedArgs> decodedTextStreamCallingArgs = new ArrayList<DecodedArgs>();
            ArrayList<DecodedArgs> decodedBinaryCallingArgs = new ArrayList<DecodedArgs>();
            ArrayList<DecodedArgs> decodedBinaryStreamCallingArgs = new ArrayList<DecodedArgs>();
            for (AvailableDecoders.RegisteredDecoder decoder : metadata.getAvailableDecoders()) {
                if (decoder.implementsInterface(Decoder.Text.class)) {
                    decodedTextCallingArgs.add(new DecodedArgs(decoder, new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(decoder.objectType).required()));
                }
                if (decoder.implementsInterface(Decoder.TextStream.class)) {
                    decodedTextStreamCallingArgs.add(new DecodedArgs(decoder, new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(decoder.objectType).required()));
                }
                if (decoder.implementsInterface(Decoder.Binary.class)) {
                    decodedBinaryCallingArgs.add(new DecodedArgs(decoder, new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(decoder.objectType).required()));
                }
                if (!decoder.implementsInterface(Decoder.BinaryStream.class)) continue;
                decodedBinaryStreamCallingArgs.add(new DecodedArgs(decoder, new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(decoder.objectType).required()));
            }
            block1: for (Method onMsg : onMessages) {
                this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                OnMessage onMessageAnno = onMsg.getAnnotation(OnMessage.class);
                JavaxWebSocketFrameHandlerMetadata.MessageMetadata msgMetadata = new JavaxWebSocketFrameHandlerMetadata.MessageMetadata();
                if (onMessageAnno.maxMessageSize() > Integer.MAX_VALUE) {
                    throw new InvalidWebSocketException(String.format("Value too large: %s#%s - @OnMessage.maxMessageSize=%,d > Integer.MAX_VALUE", endpointClass.getName(), onMsg.getName(), onMessageAnno.maxMessageSize()));
                }
                msgMetadata.maxMessageSize = (int)onMessageAnno.maxMessageSize();
                MethodHandle methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), textCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = StringMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setTextMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), textPartialCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = PartialStringMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setTextMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), binaryBufferCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = ByteBufferMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), binaryPartialBufferCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = PartialByteBufferMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), binaryArrayCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = ByteArrayMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), binaryPartialArrayCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = PartialByteArrayMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), inputStreamCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = InputStreamMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), readerCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = ReaderMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    metadata.setTextMetadata(msgMetadata, onMsg);
                    continue;
                }
                for (DecodedArgs decodedArgs : decodedTextCallingArgs) {
                    methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), decodedArgs.args);
                    if (methodHandle2 == null) continue;
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = DecodedTextMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    msgMetadata.registeredDecoder = decodedArgs.registeredDecoder;
                    metadata.setTextMetadata(msgMetadata, onMsg);
                    continue block1;
                }
                for (DecodedArgs decodedArgs : decodedBinaryCallingArgs) {
                    methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), decodedArgs.args);
                    if (methodHandle2 == null) continue;
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = DecodedBinaryMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    msgMetadata.registeredDecoder = decodedArgs.registeredDecoder;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue block1;
                }
                for (DecodedArgs decodedArgs : decodedTextStreamCallingArgs) {
                    methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), decodedArgs.args);
                    if (methodHandle2 == null) continue;
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = DecodedTextStreamMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    msgMetadata.registeredDecoder = decodedArgs.registeredDecoder;
                    metadata.setTextMetadata(msgMetadata, onMsg);
                    continue block1;
                }
                for (DecodedArgs decodedArgs : decodedBinaryStreamCallingArgs) {
                    methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), decodedArgs.args);
                    if (methodHandle2 == null) continue;
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    msgMetadata.sinkClass = DecodedBinaryStreamMessageSink.class;
                    msgMetadata.handle = methodHandle2;
                    msgMetadata.registeredDecoder = decodedArgs.registeredDecoder;
                    metadata.setBinaryMetadata(msgMetadata, onMsg);
                    continue block1;
                }
                methodHandle2 = InvokerUtils.optionalMutatedInvoker(endpointClass, onMsg, this.paramIdentifier, metadata.getNamedTemplateVariables(), pongCallingArgs);
                if (methodHandle2 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                    metadata.setPongHandle(methodHandle2, onMsg);
                    continue;
                }
                throw InvalidSignatureException.build(endpointClass, OnMessage.class, onMsg);
            }
        }
        return metadata;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        if (!OnMessage.class.isAssignableFrom(annotationClass)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" return must be void: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
    }

    static {
        try {
            FILTER_RETURN_TYPE_METHOD = MethodHandles.lookup().findVirtual(JavaxWebSocketSession.class, "filterReturnType", MethodType.methodType(Void.TYPE, Object.class));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static class DecodedArgs {
        public final AvailableDecoders.RegisteredDecoder registeredDecoder;
        public final InvokerUtils.Arg[] args;

        public DecodedArgs(AvailableDecoders.RegisteredDecoder registeredDecoder, InvokerUtils.Arg ... args) {
            this.registeredDecoder = registeredDecoder;
            this.args = args;
        }
    }
}

