/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;

public class ByteBufferMessageSink
extends AbstractMessageSink {
    private static final int BUFFER_SIZE = 65535;
    private ByteArrayOutputStream out;
    private int size;

    public ByteBufferMessageSink(JavaxWebSocketSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload()) {
                ByteBuffer payload = frame.getPayload();
                this.size += payload.remaining();
                if (this.session.getMaxBinaryMessageBufferSize() > 0 && this.size > this.session.getMaxBinaryMessageBufferSize()) {
                    throw new MessageTooLargeException(String.format("Binary message too large: (actual) %,d > (configured max binary buffer size) %,d", this.size, this.session.getMaxBinaryMessageBufferSize()));
                }
                if (this.out == null) {
                    this.out = new ByteArrayOutputStream(65535);
                }
                BufferUtil.writeTo((ByteBuffer)payload, (OutputStream)this.out);
                payload.position(payload.limit());
            }
            if (frame.isFin()) {
                if (this.out != null) {
                    this.methodHandle.invoke(ByteBuffer.wrap(this.out.toByteArray()));
                } else {
                    this.methodHandle.invoke(BufferUtil.EMPTY_BUFFER);
                }
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.out = null;
                this.size = 0;
            }
        }
    }
}

