/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import javax.websocket.Decoder;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.MessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractMessageSink;

public abstract class DecodedMessageSink<T extends Decoder>
extends AbstractMessageSink {
    protected final Logger logger = Log.getLogger(this.getClass());
    private final T decoder;
    private final MethodHandle rawMethodHandle;
    private final MessageSink rawMessageSink;

    public DecodedMessageSink(JavaxWebSocketSession session, T decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, methodHandle);
        this.decoder = decoder;
        this.rawMethodHandle = this.newRawMethodHandle();
        this.rawMessageSink = this.newRawMessageSink(session, this.rawMethodHandle);
    }

    protected abstract MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException;

    protected abstract MessageSink newRawMessageSink(JavaxWebSocketSession var1, MethodHandle var2);

    public T getDecoder() {
        return this.decoder;
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        this.rawMessageSink.accept(frame, callback);
    }
}

