/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.common.util.InvokerUtils;
import org.eclipse.jetty.websocket.javax.server.internal.DelegatedJavaxServletUpgradeRequest;
import org.eclipse.jetty.websocket.javax.server.internal.PathParamIdentifier;
import org.eclipse.jetty.websocket.servlet.FrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;

public class JavaxWebSocketServerFrameHandlerFactory
extends JavaxWebSocketFrameHandlerFactory
implements FrameHandlerFactory {
    public JavaxWebSocketServerFrameHandlerFactory(JavaxWebSocketContainer container) {
        super(container, (InvokerUtils.ParamIdentifier)new PathParamIdentifier());
    }

    public JavaxWebSocketFrameHandlerMetadata createMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointClass, endpointConfig);
        }
        ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            return null;
        }
        UriTemplatePathSpec templatePathSpec = new UriTemplatePathSpec(anno.value());
        JavaxWebSocketFrameHandlerMetadata metadata = new JavaxWebSocketFrameHandlerMetadata(endpointConfig);
        metadata.setUriTemplatePathSpec(templatePathSpec);
        return this.discoverJavaxFrameHandlerMetadata(endpointClass, metadata);
    }

    public FrameHandler newFrameHandler(Object websocketPojo, ServletUpgradeRequest upgradeRequest, ServletUpgradeResponse upgradeResponse) {
        return this.newJavaxWebSocketFrameHandler(websocketPojo, new DelegatedJavaxServletUpgradeRequest(upgradeRequest));
    }
}

