/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.InputStream;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.events.EventCapture;

@WebSocket
public class AnnotatedBinaryStreamSocket {
    public EventCapture capture = new EventCapture();

    @OnWebSocketMessage
    public void onBinary(InputStream stream) {
        if (stream == null) {
            new RuntimeException("Stream cannot be null").printStackTrace(System.err);
        }
        this.capture.offer("onBinary(%s)", stream);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.capture.offer("onClose(%d, %s)", statusCode, this.capture.q(reason));
    }

    @OnWebSocketConnect
    public void onConnect(Session sess) {
        this.capture.offer("onConnect(%s)", sess);
    }
}

