/*
 * Decompiled with CFR 0.152.
 */
package examples;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.events.EventCapture;

@WebSocket
public class AnnotatedTextSocket {
    public EventCapture capture = new EventCapture();

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.capture.offer("onClose(%d, %s)", statusCode, this.capture.q(reason));
    }

    @OnWebSocketConnect
    public void onConnect(Session sess) {
        this.capture.offer("onConnect(%s)", sess);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        this.capture.offer("onError(%s: %s)", cause.getClass().getSimpleName(), cause.getMessage());
    }

    @OnWebSocketMessage
    public void onText(String message) {
        this.capture.offer("onText(%s)", this.capture.q(message));
    }
}

